/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.TestRunnable;

public class GenerateIdentifiersTest
extends BasicPerformanceTest {
    private int count;

    public GenerateIdentifiersTest(int numberOfIdentifiers) {
        super("Generate " + numberOfIdentifiers + " identifiers");
        this.count = numberOfIdentifiers;
    }

    protected void runTest() throws Throwable {
        final IActivityManager activityManager = this.fWorkbench.getActivitySupport().getActivityManager();
        GenerateIdentifiersTest.exercise(new TestRunnable(){

            @Override
            public void run() throws Exception {
                String[] ids = new String[GenerateIdentifiersTest.this.count];
                int i = 0;
                while (i < ids.length) {
                    long timestamp = System.currentTimeMillis();
                    ids[i] = "org.eclipse.jdt.ui/" + i + timestamp;
                    ++i;
                }
                GenerateIdentifiersTest.this.startMeasuring();
                i = 0;
                while (i < ids.length) {
                    activityManager.getIdentifier(ids[i]);
                    ++i;
                }
                GenerateIdentifiersTest.this.stopMeasuring();
            }
        });
        this.commitMeasurements();
        this.assertPerformance();
    }
}

