/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.TestRunnable;

public class LabelProviderTest
extends BasicPerformanceTest {
    private static final int ITEM_COUNT = 2000;
    private static final int ITERATIONS = 5;
    private static final int MIN_ITERATIONS = 5;
    private CountryEntry[] entries;
    private Shell fShell;
    private StructuredViewer fViewer;
    private boolean styled;
    private boolean colors;

    public LabelProviderTest(String testName, boolean styled, boolean colors) {
        super(testName);
        this.styled = styled;
        this.colors = colors;
    }

    protected void runTest() throws Throwable {
        if (this.styled) {
            this.fViewer.setLabelProvider((IBaseLabelProvider)this.getDecoratingStyledCellLabelProvider(this.colors));
        } else {
            this.fViewer.setLabelProvider((IBaseLabelProvider)this.getDecoratingLabelProvider(this.colors));
        }
        final Tree tree = ((TreeViewer)this.fViewer).getTree();
        this.fShell.setFocus();
        LabelProviderTest.exercise(new TestRunnable(){

            @Override
            public void run() {
                LabelProviderTest.this.startMeasuring();
                int i = 0;
                while (i < 400) {
                    tree.setTopItem(tree.getItem(i * 5));
                    LabelProviderTest.processEvents();
                    ++i;
                }
                LabelProviderTest.this.stopMeasuring();
            }
        }, 5, 5, JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }

    protected StructuredViewer createViewer(Shell parent) {
        TreeViewer viewer = new TreeViewer((Composite)parent, 65536);
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return LabelProviderTest.this.entries;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return LabelProviderTest.this.entries;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        GridData data = new GridData(1808);
        viewer.getControl().setLayoutData((Object)data);
        viewer.setSelection((ISelection)new StructuredSelection((Object)this.entries[1]));
        return viewer;
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        this.entries = new CountryEntry[2000];
        int i = 0;
        while (i < this.entries.length) {
            this.entries[i] = new CountryEntry(display, i);
            ++i;
        }
        this.fShell = new Shell(display);
        this.fShell.setSize(500, 500);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = this.createViewer(this.fShell);
        this.fViewer.setUseHashlookup(true);
        this.fViewer.setInput((Object)this);
        this.fShell.open();
    }

    @Override
    protected void doTearDown() throws Exception {
        super.doTearDown();
        if (this.fShell != null) {
            this.fShell.close();
            this.fShell = null;
        }
    }

    private DecoratingStyledCellLabelProvider getDecoratingStyledCellLabelProvider(boolean useColor) {
        IDecorationContext context = new IDecorationContext(){

            public String[] getProperties() {
                return null;
            }

            public Object getProperty(String property) {
                return null;
            }
        };
        return new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TestCellLabelProvider(useColor), useColor ? this.getDecorator() : null, context);
    }

    private ILabelDecorator getDecorator() {
        return new TestLabelDecorator();
    }

    DecoratingLabelProvider getDecoratingLabelProvider(boolean useColor) {
        return new DecoratingLabelProvider(new ILabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof CountryEntry) {
                    return ((CountryEntry)element).getImage();
                }
                return null;
            }

            public String getText(Object element) {
                return element.toString();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        }, useColor ? this.getDecorator() : null);
    }

    private class CountryEntry {
        private String name = "\u00d6sterreich";
        private String cupYear = "Austria";
        private String baseName;
        private Image image;
        private Color bkColor;
        private Color fgColor;

        public CountryEntry(Display display, int i) {
            this.baseName = Integer.toString(i + 100);
            switch (i % 3) {
                case 0: {
                    this.image = display.getSystemImage(8);
                    this.bkColor = display.getSystemColor(9);
                    this.fgColor = display.getSystemColor(3);
                    break;
                }
                case 1: {
                    this.image = display.getSystemImage(1);
                    this.bkColor = display.getSystemColor(5);
                    this.fgColor = display.getSystemColor(9);
                    break;
                }
                case 2: {
                    this.image = display.getSystemImage(4);
                    this.bkColor = display.getSystemColor(3);
                    this.fgColor = display.getSystemColor(5);
                }
            }
        }

        public Image getImage() {
            return this.image;
        }

        public Color getBackgroundColor() {
            return this.bkColor;
        }

        public Color getForegroundColor() {
            return this.fgColor;
        }

        public String toString() {
            return String.valueOf(this.name) + " " + this.cupYear + " " + this.baseName;
        }
    }

    private class TestCellLabelProvider
    extends CellLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    IFontProvider {
        private boolean useColor;

        public TestCellLabelProvider(boolean useColor) {
            this.useColor = useColor;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (!(element instanceof CountryEntry)) {
                return;
            }
            cell.setText(element.toString());
            cell.setImage(this.getImage(element));
            if (this.useColor) {
                cell.setForeground(((CountryEntry)element).getForegroundColor());
                cell.setBackground(((CountryEntry)element).getBackgroundColor());
            }
        }

        public Image getImage(Object element) {
            if (element instanceof CountryEntry) {
                return ((CountryEntry)element).getImage();
            }
            return null;
        }

        public StyledString getStyledText(Object element) {
            return new StyledString(element.toString(), (StyledString.Styler)(this.useColor ? StyledString.COUNTER_STYLER : null));
        }

        public Font getFont(Object element) {
            return null;
        }
    }

    private class TestLabelDecorator
    implements ILabelDecorator,
    IColorDecorator {
        private TestLabelDecorator() {
        }

        public Image decorateImage(Image image, Object element) {
            return image;
        }

        public String decorateText(String text, Object element) {
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color decorateBackground(Object element) {
            if (element instanceof CountryEntry) {
                return ((CountryEntry)element).getBackgroundColor();
            }
            return null;
        }

        public Color decorateForeground(Object element) {
            if (element instanceof CountryEntry) {
                return ((CountryEntry)element).getForegroundColor();
            }
            return null;
        }
    }
}

