/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import org.eclipse.core.resources.IFile;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.TestRunnable;

public class OpenCloseEditorTest
extends BasicPerformanceTest {
    private String extension;

    public OpenCloseEditorTest(String extension, int tagging) {
        super("testOpenAndCloseEditors:" + extension, tagging);
        this.extension = extension;
    }

    protected void runTest() throws Throwable {
        final IFile file = this.getProject().getFile("1." + this.extension);
        OpenCloseEditorTest.assertTrue((boolean)file.exists());
        IWorkbenchWindow window = this.openTestWindow("org.eclipse.ui.tests.performancePerspective1");
        final IWorkbenchPage activePage = window.getActivePage();
        OpenCloseEditorTest.exercise(new TestRunnable(){

            @Override
            public void run() throws Exception {
                OpenCloseEditorTest.this.startMeasuring();
                int j = 0;
                while (j < 10) {
                    IEditorPart part = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
                    OpenCloseEditorTest.processEvents();
                    activePage.closeEditor(part, false);
                    OpenCloseEditorTest.processEvents();
                    ++j;
                }
                OpenCloseEditorTest.this.stopMeasuring();
            }
        });
        this.tagIfNecessary("UI - Open/Close Editor", Dimension.ELAPSED_PROCESS);
        this.commitMeasurements();
        this.assertPerformance();
    }
}

