/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.EditorTestHelper;
import org.eclipse.ui.tests.performance.TestRunnable;

public class OpenClosePerspectiveTest
extends BasicPerformanceTest {
    private String id;

    public OpenClosePerspectiveTest(String id, int tagging) {
        super("testOpenClosePerspectives:" + id, tagging);
        this.id = id;
    }

    protected void runTest() throws Throwable {
        IPerspectiveRegistry registry = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        final IPerspectiveDescriptor perspective1 = registry.findPerspectiveWithId(this.id);
        if (perspective1 == null) {
            System.out.println("Unknown perspective id: " + this.id);
            return;
        }
        IWorkbenchWindow window = this.openTestWindow();
        final IWorkbenchPage activePage = window.getActivePage();
        activePage.setPerspective(perspective1);
        IViewReference[] refs = activePage.getViewReferences();
        String[] ids = new String[refs.length];
        int i = 0;
        while (i < refs.length) {
            ids[i] = refs[i].getId();
            ++i;
        }
        this.closePerspective(activePage);
        i = 0;
        while (i < ids.length) {
            activePage.showView(ids[i]);
            ++i;
        }
        this.tagIfNecessary("UI - Open/Close " + perspective1.getLabel() + " Perspective", Dimension.ELAPSED_PROCESS);
        OpenClosePerspectiveTest.exercise(new TestRunnable(){

            @Override
            public void run() throws Exception {
                OpenClosePerspectiveTest.processEvents();
                EditorTestHelper.calmDown(500L, 30000L, 500L);
                OpenClosePerspectiveTest.this.startMeasuring();
                activePage.setPerspective(perspective1);
                OpenClosePerspectiveTest.processEvents();
                OpenClosePerspectiveTest.this.closePerspective(activePage);
                OpenClosePerspectiveTest.processEvents();
                OpenClosePerspectiveTest.this.stopMeasuring();
            }
        });
        this.commitMeasurements();
        this.assertPerformance();
    }

    private void closePerspective(IWorkbenchPage activePage) {
        IPerspectiveDescriptor persp = activePage.getPerspective();
        ICommandService commandService = (ICommandService)this.fWorkbench.getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.window.closePerspective");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.eclipse.ui.window.closePerspective.perspectiveId", persp.getId());
        ParameterizedCommand pCommand = ParameterizedCommand.generateCommand((Command)command, parameters);
        IHandlerService handlerService = (IHandlerService)this.fWorkbench.getService(IHandlerService.class);
        try {
            handlerService.executeCommand(pCommand, null);
        }
        catch (ExecutionException executionException) {
        }
        catch (NotDefinedException notDefinedException) {
        }
        catch (NotEnabledException notEnabledException) {
        }
        catch (NotHandledException notHandledException) {}
    }
}

