/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;

public class OpenCloseViewTest
extends BasicPerformanceTest {
    private String viewId;

    public OpenCloseViewTest(String viewId, int tagging) {
        super("showView:" + viewId, tagging);
        this.viewId = viewId;
    }

    protected void runTest() throws Throwable {
        IWorkbenchWindow window = this.openTestWindow();
        IWorkbenchPage page = window.getActivePage();
        IViewPart view1 = page.showView(this.viewId);
        page.hideView(view1);
        OpenCloseViewTest.waitForBackgroundJobs();
        OpenCloseViewTest.processEvents();
        this.tagIfNecessary("UI - Open/Close " + view1.getTitle(), Dimension.ELAPSED_PROCESS);
        if ("org.eclipse.ui.views.BookmarkView".equals(this.viewId)) {
            this.setDegradationComment("The test results are influenced by the test machine setup. See bug 340136.");
        }
        int j = 0;
        while (j < 100) {
            this.startMeasuring();
            int i = 0;
            while (i < 5) {
                IViewPart view = page.showView(this.viewId);
                OpenCloseViewTest.processEvents();
                page.hideView(view);
                OpenCloseViewTest.processEvents();
                ++i;
            }
            this.stopMeasuring();
            ++j;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

