/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import org.eclipse.core.resources.IFile;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;

public class OpenMultipleEditorTest
extends BasicPerformanceTest {
    private String extension;
    private boolean closeAll;

    public OpenMultipleEditorTest(String extension, boolean closeAll, int tagging) {
        super("testOpenMultipleEditors:" + extension + (closeAll ? "[closeAll]" : "[closeEach]"), tagging);
        this.extension = extension;
        this.closeAll = closeAll;
    }

    protected void runTest() throws Throwable {
        IWorkbenchWindow window = this.openTestWindow("org.eclipse.ui.tests.performancePerspective1");
        IWorkbenchPage activePage = window.getActivePage();
        this.tagIfNecessary("UI - Open Multiple Editors", Dimension.ELAPSED_PROCESS);
        this.startMeasuring();
        int i = 0;
        while (i < 100) {
            IFile file = this.getProject().getFile(String.valueOf(i) + "." + this.extension);
            IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
            OpenMultipleEditorTest.processEvents();
            ++i;
        }
        if (this.closeAll) {
            activePage.closeAllEditors(false);
        } else {
            IEditorPart[] parts = activePage.getEditors();
            int i2 = 0;
            while (i2 < parts.length) {
                activePage.closeEditor(parts[i2], false);
                ++i2;
            }
        }
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }
}

