/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.TestRunnable;

public class PerspectiveSwitchTest
extends BasicPerformanceTest {
    private String id1;
    private String id2;
    private String activeEditor;

    public PerspectiveSwitchTest(String[] ids, int tagging) {
        super("testPerspectiveSwitch:" + ids[0] + "," + ids[1] + ",editor " + ids[2], tagging);
        this.id1 = ids[0];
        this.id2 = ids[1];
        this.activeEditor = ids[2];
    }

    protected void runTest() throws CoreException, WorkbenchException {
        IPerspectiveRegistry registry = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        final IPerspectiveDescriptor perspective1 = registry.findPerspectiveWithId(this.id1);
        final IPerspectiveDescriptor perspective2 = registry.findPerspectiveWithId(this.id2);
        if (perspective1 == null) {
            System.out.println("Unknown perspective ID: " + this.id1);
            return;
        }
        if (perspective2 == null) {
            System.out.println("Unknown perspective ID: " + this.id2);
            return;
        }
        IWorkbenchWindow window = this.openTestWindow(this.id1);
        final IWorkbenchPage page = window.getActivePage();
        PerspectiveSwitchTest.assertNotNull((Object)page);
        page.setPerspective(perspective2);
        IFile aFile = this.getProject().getFile(this.activeEditor);
        PerspectiveSwitchTest.assertTrue((boolean)aFile.exists());
        IDE.openEditor((IWorkbenchPage)page, (IFile)aFile, (boolean)true);
        this.tagIfNecessary("UI - Perspective Switch", Dimension.ELAPSED_PROCESS);
        PerspectiveSwitchTest.exercise(new TestRunnable(){

            @Override
            public void run() throws Exception {
                PerspectiveSwitchTest.processEvents();
                PerspectiveSwitchTest.this.startMeasuring();
                page.setPerspective(perspective1);
                PerspectiveSwitchTest.processEvents();
                page.setPerspective(perspective2);
                PerspectiveSwitchTest.processEvents();
                PerspectiveSwitchTest.this.stopMeasuring();
            }
        });
        this.commitMeasurements();
        this.assertPerformance();
    }
}

