/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.performance.EditorPerformanceSuite;
import org.eclipse.ui.tests.performance.EditorTestHelper;
import org.eclipse.ui.tests.performance.ResourceTestHelper;

public class UIPerformanceTestSetup
extends TestSetup {
    public static final String PERSPECTIVE1 = "org.eclipse.ui.tests.performancePerspective1";
    public static final String PERSPECTIVE2 = "org.eclipse.ui.tests.performancePerspective2";
    public static final String PROJECT_NAME = "Performance Project";
    private static final String INTRO_VIEW = "org.eclipse.ui.internal.introview";
    private IProject testProject;

    public UIPerformanceTestSetup(Test test) {
        super(test);
    }

    protected void setUp() throws Exception {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWindow.getActivePage();
        activePage.hideView(activePage.findViewReference(INTRO_VIEW));
        workbench.showPerspective(PERSPECTIVE1, activeWindow);
        boolean wasAutobuilding = ResourceTestHelper.disableAutoBuilding();
        this.setUpProject();
        ResourceTestHelper.fullBuild();
        if (wasAutobuilding) {
            ResourceTestHelper.enableAutoBuilding();
            EditorTestHelper.calmDown(2000L, 30000L, 1000L);
        }
    }

    protected void tearDown() throws Exception {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        int i = 0;
        while (i < elements.length) {
            StackTraceElement element = elements[i];
            if (element.getClassName().equals("org.eclipse.test.EclipseTestRunner")) {
                PlatformUI.getWorkbench().close();
                break;
            }
            ++i;
        }
    }

    private void setUpProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.testProject = workspace.getRoot().getProject(PROJECT_NAME);
        this.testProject.create(null);
        this.testProject.open(null);
        int i = 0;
        while (i < EditorPerformanceSuite.EDITOR_FILE_EXTENSIONS.length) {
            this.createFiles(EditorPerformanceSuite.EDITOR_FILE_EXTENSIONS[i]);
            ++i;
        }
    }

    private void createFiles(String ext) throws CoreException {
        int i = 0;
        while (i < 100) {
            String fileName = String.valueOf(i) + "." + ext;
            IFile iFile = this.testProject.getFile(fileName);
            iFile.create((InputStream)new ByteArrayInputStream(new byte[]{10}), true, null);
            ++i;
        }
    }
}

