/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.performance.OpenCloseViewTest;
import org.eclipse.ui.tests.performance.OpenNavigatorFolderTest;
import org.eclipse.ui.tests.performance.layout.ResizeTest;
import org.eclipse.ui.tests.performance.layout.ViewWidgetFactory;
import org.eclipse.ui.views.IViewDescriptor;

public class ViewPerformanceSuite
extends TestSuite {
    public static final String PROJECT_EXPLORER = "org.eclipse.ui.navigator.ProjectExplorer";
    public static final String BASIC_PATH = "org.eclipse.ui";
    public static final String VIEWS_PATTERN = "org.eclipse.ui.views";

    public static Test suite() {
        return new ViewPerformanceSuite();
    }

    public ViewPerformanceSuite() {
        this.addOpenCloseTests();
        this.addResizeTests();
        this.addTestSuite(OpenNavigatorFolderTest.class);
    }

    private void addOpenCloseTests() {
        String[] ids = ViewPerformanceSuite.getAllTestableViewIds();
        int i = 0;
        while (i < ids.length) {
            String id;
            this.addTest((Test)new OpenCloseViewTest(id, (id = ids[i]).equals(PROJECT_EXPLORER) ? 2 : 0));
            ++i;
        }
    }

    private void addResizeTests() {
        String[] ids = ViewPerformanceSuite.getAllTestableViewIds();
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            this.addTest((Test)new ResizeTest(new ViewWidgetFactory(id)));
            ++i;
        }
    }

    public static String[] getAllTestableViewIds() {
        HashSet<String> result = new HashSet<String>();
        IViewDescriptor[] descriptors = PlatformUI.getWorkbench().getViewRegistry().getViews();
        int i = 0;
        while (i < descriptors.length) {
            IViewDescriptor descriptor = descriptors[i];
            String[] categoryPath = descriptor.getCategoryPath();
            if (categoryPath != null) {
                int j = 0;
                while (j < categoryPath.length) {
                    if (categoryPath[j].equals(BASIC_PATH) && (descriptor.getId().indexOf(VIEWS_PATTERN) >= 0 || descriptor.getId().equals(PROJECT_EXPLORER))) {
                        result.add(descriptor.getId());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }
}

