/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance.layout;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.layout.TestWidgetFactory;

public class ComputeSizeTest
extends BasicPerformanceTest {
    private TestWidgetFactory widgetFactory;
    private int xIterations = 10;
    private int yIterations = 10;

    public ComputeSizeTest(TestWidgetFactory widgetFactory) {
        super(String.valueOf(widgetFactory.getName()) + " computeSize");
        this.widgetFactory = widgetFactory;
    }

    protected void runTest() throws CoreException, WorkbenchException {
        this.widgetFactory.init();
        Composite widget = this.widgetFactory.getControl();
        Point maxSize = this.widgetFactory.getMaxSize();
        int[] counter = new int[1];
        int j = 0;
        while (j < 100) {
            int count = counter[0];
            this.startMeasuring();
            int i = 0;
            while (i < 200) {
                int xIteration = 0;
                while (xIteration < this.xIterations) {
                    int yIteration = 0;
                    while (yIteration < this.yIterations) {
                        int xSize = maxSize.x * ((xIteration + yIteration) % this.xIterations) / this.xIterations;
                        int ySize = maxSize.y * yIteration / this.yIterations;
                        boolean flushState = count % 2 != 0;
                        switch (count % 4) {
                            case 0: {
                                widget.computeSize(xSize, -1, flushState);
                                break;
                            }
                            case 1: {
                                widget.computeSize(-1, ySize, flushState);
                                break;
                            }
                            case 2: {
                                widget.computeSize(xSize, ySize, flushState);
                                break;
                            }
                            case 3: {
                                widget.computeSize(-1, -1, flushState);
                            }
                        }
                        ++count;
                        ++yIteration;
                    }
                    ++xIteration;
                }
                ++i;
            }
            this.stopMeasuring();
            ComputeSizeTest.processEvents();
            counter[0] = counter[0] + 1;
            ++j;
        }
        this.commitMeasurements();
        this.assertPerformance();
        this.widgetFactory.done();
    }
}

