/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance.layout;

import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.tests.harness.util.UITestCase;
import org.eclipse.ui.tests.performance.layout.TestWidgetFactory;

public class EditorWidgetFactory
extends TestWidgetFactory {
    private String editorId;
    private String filename;
    private IWorkbenchWindow window;
    private Composite ctrl;

    public EditorWidgetFactory(String filename) {
        this.filename = filename;
        this.editorId = null;
    }

    public EditorWidgetFactory(String filename, String editorId) {
        this.filename = filename;
        this.editorId = editorId;
    }

    public static Composite getControl(IEditorPart part) {
        EditorSite site = (EditorSite)part.getSite();
        MPart modelPart = site.getModel();
        return (Composite)modelPart.getWidget();
    }

    @Override
    public String getName() {
        return "editor " + this.filename + (this.editorId != null ? this.editorId : "");
    }

    @Override
    public void init() throws CoreException, WorkbenchException {
        this.window = PlatformUI.getWorkbench().openWorkbenchWindow("org.eclipse.ui.tests.harness.util.EmptyPerspective", UITestCase.getPageInput());
        IWorkbenchPage activePage = this.window.getActivePage();
        Assert.assertNotNull((Object)activePage);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject testProject = workspace.getRoot().getProject("Performance Project");
        IFile file = testProject.getFile(this.filename);
        if (this.editorId == null) {
            this.editorId = IDE.getEditorDescriptor((IFile)file).getId();
        }
        IEditorPart part = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (String)this.editorId, (boolean)true);
        this.ctrl = EditorWidgetFactory.getControl(part);
    }

    @Override
    public Composite getControl() throws CoreException, WorkbenchException {
        return this.ctrl;
    }

    @Override
    public void done() throws CoreException, WorkbenchException {
        this.window.close();
        super.done();
    }
}

