/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance.layout;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.layout.TestWidgetFactory;

public class LayoutTest
extends BasicPerformanceTest {
    private TestWidgetFactory widgetFactory;
    private int xIterations = 100;
    private int yIterations = 10;
    private boolean flushState;

    public LayoutTest(TestWidgetFactory widgetFactory, boolean flushState) {
        super(String.valueOf(widgetFactory.getName()) + " layout(" + (flushState ? "true" : "false") + ")");
        this.widgetFactory = widgetFactory;
        this.flushState = flushState;
    }

    protected void runTest() throws CoreException, WorkbenchException {
        this.widgetFactory.init();
        Composite widget = this.widgetFactory.getControl();
        Point maxSize = this.widgetFactory.getMaxSize();
        Rectangle initialBounds = widget.getBounds();
        Rectangle newBounds = Geometry.copy((Rectangle)initialBounds);
        int xIteration = 0;
        while (xIteration < this.xIterations) {
            LayoutTest.processEvents();
            this.startMeasuring();
            int yIteration = 0;
            while (yIteration < this.yIterations) {
                int xSize = maxSize.x * ((xIteration + yIteration) % this.xIterations) / this.xIterations;
                int ySize = maxSize.y * yIteration / this.yIterations;
                newBounds.width = xSize;
                newBounds.height = ySize;
                widget.setBounds(newBounds);
                widget.layout(this.flushState);
                ++yIteration;
            }
            this.stopMeasuring();
            ++xIteration;
        }
        this.commitMeasurements();
        this.assertPerformance();
        widget.setBounds(initialBounds);
        this.widgetFactory.done();
    }
}

