/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.tests.harness.util.RCPTestWorkbenchAdvisor;
import org.eclipse.ui.tests.rcp.CheckForWorkbench;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PlatformUITest {
    @Test(expected=IllegalStateException.class)
    public void testEarlyGetWorkbench() {
        Assert.assertFalse((boolean)PlatformUI.isWorkbenchRunning());
        PlatformUI.getWorkbench();
    }

    @Test
    public void testCreateDisplay() {
        Display disp = PlatformUI.createDisplay();
        Assert.assertNotNull((Object)disp);
        Assert.assertFalse((boolean)disp.isDisposed());
        disp.dispose();
        Assert.assertTrue((boolean)disp.isDisposed());
    }

    @Test
    public void testCreateAndRunWorkbench() {
        Display display = PlatformUI.createDisplay();
        Assert.assertNotNull((Object)display);
        CheckForWorkbench wa = new CheckForWorkbench(2);
        int code = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
        Assert.assertTrue((boolean)wa.checkComplete);
        display.dispose();
        Assert.assertTrue((boolean)display.isDisposed());
        Assert.assertEquals((String)"Async run during startup.  See RCPTestWorkbenchAdvisor.preStartup()", (Object)Boolean.FALSE, (Object)RCPTestWorkbenchAdvisor.asyncDuringStartup);
        Assert.assertEquals((String)"Sync from qualified thread did not run during startup.  See RCPTestWorkbenchAdvisor.preStartup()", (Object)Boolean.TRUE, (Object)RCPTestWorkbenchAdvisor.syncWithDisplayAccess);
        Assert.assertEquals((String)"Async from qualified thread did not run during startup.  See RCPTestWorkbenchAdvisor.preStartup()", (Object)Boolean.TRUE, (Object)RCPTestWorkbenchAdvisor.asyncWithDisplayAccess);
        Assert.assertEquals((String)"Sync from un-qualified thread ran during startup.  See RCPTestWorkbenchAdvisor.preStartup()", (Object)Boolean.FALSE, (Object)RCPTestWorkbenchAdvisor.syncWithoutDisplayAccess);
        Assert.assertEquals((String)"Async from un-qualified thread ran during startup.  See RCPTestWorkbenchAdvisor.preStartup()", (Object)Boolean.FALSE, (Object)RCPTestWorkbenchAdvisor.asyncWithoutDisplayAccess);
        Assert.assertFalse((String)"DisplayAccess.accessDisplayDuringStartup() in UI thread did not result in exception.", (boolean)RCPTestWorkbenchAdvisor.displayAccessInUIThreadAllowed);
    }

    @Ignore
    @Test
    public void testCreateAndRunWorkbenchWithExceptionOnStartup() {
        Display display = PlatformUI.createDisplay();
        Assert.assertNotNull((Object)display);
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void preStartup() {
                throw new IllegalArgumentException("Thrown deliberately by PlatformUITest");
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)2L, (long)code);
        Assert.assertFalse((boolean)PlatformUI.isWorkbenchRunning());
        display.dispose();
        Assert.assertTrue((boolean)display.isDisposed());
    }
}

