/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.tests.harness.util.RCPTestWorkbenchAdvisor;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class WorkbenchConfigurerTest {
    private Display display = null;

    @Before
    public void setUp() {
        Assert.assertNull((Object)this.display);
        this.display = PlatformUI.createDisplay();
        Assert.assertNotNull((Object)this.display);
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.display);
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
    }

    @Ignore
    @Test
    public void testDefaults() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){
            private IWorkbenchConfigurer configurer;

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                this.configurer = c;
                Assert.assertNotNull((Object)c.getWorkbench());
                Assert.assertFalse((boolean)c.getSaveAndRestore());
                Assert.assertNotNull((Object)c.getWorkbenchWindowManager());
            }

            @Override
            public void postShutdown() {
                super.postShutdown();
                Assert.assertFalse((boolean)this.configurer.emergencyClosing());
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
    }

    @Ignore
    @Test
    public void testEmergencyClose() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(2){
            private IWorkbenchConfigurer configurer;

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                this.configurer = c;
                Assert.assertNotNull((Object)c.getWorkbench());
                Assert.assertFalse((boolean)c.getSaveAndRestore());
                Assert.assertNotNull((Object)c.getWorkbenchWindowManager());
            }

            public void eventLoopIdle(Display disp) {
                super.eventLoopIdle(disp);
                this.configurer.emergencyClose();
            }

            @Override
            public void postShutdown() {
                super.postShutdown();
                Assert.assertTrue((boolean)this.configurer.emergencyClosing());
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)3L, (long)code);
    }

    @Test
    public void testThreading() {
        final ArrayList results = new ArrayList();
        RCPTestWorkbenchAdvisor advisor = new RCPTestWorkbenchAdvisor(1){

            public void createWindowContents(IWorkbenchWindowConfigurer configurer, Shell shell) {
                this.ensureThread();
                super.createWindowContents(configurer, shell);
            }

            private void ensureThread() {
                if (Display.getCurrent() != null) {
                    return;
                }
                Exception e = new Exception();
                e.fillInStackTrace();
                results.add(e);
            }

            public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
                this.ensureThread();
                return super.createWorkbenchWindowAdvisor(configurer);
            }

            public void eventLoopException(Throwable exception) {
                this.ensureThread();
                super.eventLoopException(exception);
            }

            public void eventLoopIdle(Display display) {
                this.ensureThread();
                super.eventLoopIdle(display);
            }

            public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer configurer, int flags) {
                this.ensureThread();
                super.fillActionBars(window, configurer, flags);
            }

            public IAdaptable getDefaultPageInput() {
                this.ensureThread();
                return super.getDefaultPageInput();
            }

            public String getMainPreferencePageId() {
                this.ensureThread();
                return super.getMainPreferencePageId();
            }

            protected IWorkbenchConfigurer getWorkbenchConfigurer() {
                this.ensureThread();
                return super.getWorkbenchConfigurer();
            }

            public void initialize(IWorkbenchConfigurer configurer) {
                this.ensureThread();
                super.initialize(configurer);
            }

            public boolean isApplicationMenu(IWorkbenchWindowConfigurer configurer, String menuId) {
                this.ensureThread();
                return super.isApplicationMenu(configurer, menuId);
            }

            public void openIntro(IWorkbenchWindowConfigurer configurer) {
                this.ensureThread();
                super.openIntro(configurer);
            }

            public boolean openWindows() {
                this.ensureThread();
                return super.openWindows();
            }

            public void postShutdown() {
                this.ensureThread();
                super.postShutdown();
            }

            public void postStartup() {
                this.ensureThread();
                super.postStartup();
            }

            public void postWindowClose(IWorkbenchWindowConfigurer configurer) {
                this.ensureThread();
                super.postWindowClose(configurer);
            }

            public void postWindowCreate(IWorkbenchWindowConfigurer configurer) {
                this.ensureThread();
                super.postWindowCreate(configurer);
            }

            public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
                this.ensureThread();
                super.postWindowOpen(configurer);
            }

            public void postWindowRestore(IWorkbenchWindowConfigurer configurer) throws WorkbenchException {
                this.ensureThread();
                super.postWindowRestore(configurer);
            }

            public boolean preShutdown() {
                this.ensureThread();
                return super.preShutdown();
            }

            public void preStartup() {
                this.ensureThread();
                super.preStartup();
            }

            public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
                this.ensureThread();
                super.preWindowOpen(configurer);
            }

            public boolean preWindowShellClose(IWorkbenchWindowConfigurer configurer) {
                this.ensureThread();
                return super.preWindowShellClose(configurer);
            }

            public IStatus restoreState(IMemento memento) {
                this.ensureThread();
                return super.restoreState(memento);
            }

            public IStatus saveState(IMemento memento) {
                this.ensureThread();
                return super.saveState(memento);
            }

            public String getInitialWindowPerspectiveId() {
                return null;
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)advisor);
        Assert.assertEquals((long)0L, (long)code);
        if (!results.isEmpty()) {
            StringBuffer buffer = new StringBuffer("Advisor methods called from non-UI threads:\n");
            int count = 0;
            for (Exception e : results) {
                StackTraceElement[] stack = e.getStackTrace();
                buffer.append("Failure ").append(++count).append('\n');
                int j = 1;
                while (j < Math.min(stack.length, 10)) {
                    StackTraceElement stackTraceElement = stack[j];
                    buffer.append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName()).append(":").append(stackTraceElement.getLineNumber()).append('\n');
                    ++j;
                }
            }
            Assert.fail((String)buffer.toString());
        }
    }
}

