/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkbenchListenerTest {
    private Display display = null;

    @Before
    public void setUp() throws Exception {
        Assert.assertNull((Object)this.display);
        this.display = PlatformUI.createDisplay();
        Assert.assertNotNull((Object)this.display);
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertNotNull((Object)this.display);
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
    }

    @Test
    public void testPreAndPostShutdown() {
        final boolean[] proceed = new boolean[1];
        final ArrayList operations = new ArrayList();
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void postStartup() {
                IWorkbench workbench = this.getWorkbenchConfigurer().getWorkbench();
                workbench.addWorkbenchListener(new IWorkbenchListener(){

                    public boolean preShutdown(IWorkbench workbench, boolean forced) {
                        operations.add("preShutdown");
                        return proceed[0];
                    }

                    public void postShutdown(IWorkbench workbench) {
                        operations.add("postShutdown");
                    }
                });
                proceed[0] = false;
                Assert.assertEquals((Object)false, (Object)workbench.close());
                proceed[0] = true;
                Assert.assertEquals((Object)true, (Object)workbench.close());
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
        Assert.assertEquals((long)3L, (long)operations.size());
        Assert.assertEquals((Object)"preShutdown", operations.get(0));
        Assert.assertEquals((Object)"preShutdown", operations.get(1));
        Assert.assertEquals((Object)"postShutdown", operations.get(2));
    }
}

