/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed;

import junit.framework.TestCase;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.views.properties.tabbed.model.Error;
import org.eclipse.ui.tests.views.properties.tabbed.model.File;
import org.eclipse.ui.tests.views.properties.tabbed.model.Folder;
import org.eclipse.ui.tests.views.properties.tabbed.model.Information;
import org.eclipse.ui.tests.views.properties.tabbed.model.Warning;
import org.eclipse.ui.tests.views.properties.tabbed.override.OverrideTestsView;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;

public class TabbedPropertySheetPageOverrideTest
extends TestCase {
    private OverrideTestsView overrideTestsView;

    protected void setUp() throws Exception {
        super.setUp();
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TabbedPropertySheetPageOverrideTest.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        TabbedPropertySheetPageOverrideTest.assertNotNull((Object)workbenchPage);
        workbenchPage.closeAllPerspectives(false, false);
        PlatformUI.getWorkbench().showPerspective("org.eclipse.ui.tests.views.properties.tabbed.views.TestsPerspective", workbenchWindow);
        IViewPart view = workbenchPage.showView("org.eclipse.ui.tests.views.properties.tabbed.override.OverrideTestsView");
        TabbedPropertySheetPageOverrideTest.assertNotNull((Object)view);
        TabbedPropertySheetPageOverrideTest.assertTrue((boolean)(view instanceof OverrideTestsView));
        this.overrideTestsView = (OverrideTestsView)view;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public void test_tabForEmpty() {
        this.overrideTestsView.setSelection(null);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Empty Item", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((int)1, (int)tabDescriptors.length);
    }

    public void test_tabForError() {
        this.overrideTestsView.setSelection(Error.class);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Information", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Warning", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Error", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Error", (String)this.overrideTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((int)3, (int)tabDescriptors.length);
    }

    public void test_tabForFile() {
        this.overrideTestsView.setSelection(File.class);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"File", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"File", (String)this.overrideTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Folder", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((int)2, (int)tabDescriptors.length);
    }

    public void test_tabForFolder() {
        this.overrideTestsView.setSelection(Folder.class);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"File", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Folder", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Folder", (String)this.overrideTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((int)2, (int)tabDescriptors.length);
    }

    public void test_tabForInformation() {
        this.overrideTestsView.setSelection(Information.class);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Information", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Information", (String)this.overrideTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Warning", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Error", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((int)3, (int)tabDescriptors.length);
    }

    public void test_tabForWarning() {
        this.overrideTestsView.setSelection(Warning.class);
        ITabDescriptor[] tabDescriptors = this.overrideTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Information", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Warning", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Warning", (String)this.overrideTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((String)"Error", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageOverrideTest.assertEquals((int)3, (int)tabDescriptors.length);
    }
}

