/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed;

import junit.framework.TestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.tests.views.properties.tabbed.sections.InformationTwoSection;
import org.eclipse.ui.tests.views.properties.tabbed.sections.NameSection;
import org.eclipse.ui.tests.views.properties.tabbed.views.TestsView;
import org.eclipse.ui.tests.views.properties.tabbed.views.TestsViewContentProvider;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabContents;

public class TabbedPropertySheetPageTest
extends TestCase {
    private TestsView testsView;
    private TreeNode[] treeNodes;

    protected void setUp() throws Exception {
        super.setUp();
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TabbedPropertySheetPageTest.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        TabbedPropertySheetPageTest.assertNotNull((Object)workbenchPage);
        workbenchPage.closeAllPerspectives(false, false);
        PlatformUI.getWorkbench().showPerspective("org.eclipse.ui.tests.views.properties.tabbed.views.TestsPerspective", workbenchWindow);
        IViewPart view = workbenchPage.showView("org.eclipse.ui.tests.views.properties.tabbed.views.TestsView");
        TabbedPropertySheetPageTest.assertNotNull((Object)view);
        TabbedPropertySheetPageTest.assertTrue((boolean)(view instanceof TestsView));
        this.testsView = (TestsView)view;
        IContentProvider contentProvider = this.testsView.getViewer().getContentProvider();
        TabbedPropertySheetPageTest.assertTrue((boolean)(contentProvider instanceof TestsViewContentProvider));
        TestsViewContentProvider viewContentProvider = (TestsViewContentProvider)contentProvider;
        this.treeNodes = viewContentProvider.getInvisibleRoot().getChildren();
        TabbedPropertySheetPageTest.assertEquals((int)this.treeNodes.length, (int)8);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        while (Display.getCurrent().readAndDispatch()) {
        }
        this.setSelection(new TreeNode[0]);
    }

    private void setSelection(TreeNode[] selectedNodes) {
        StructuredSelection selection = new StructuredSelection((Object[])selectedNodes);
        this.testsView.getViewer().setSelection((ISelection)selection, true);
    }

    public void test_tabDisplay() {
        this.setSelection(new TreeNode[]{this.treeNodes[0]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageTest.assertEquals((String)"Name", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageTest.assertEquals((String)"Information", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageTest.assertEquals((String)"Message", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageTest.assertEquals((int)3, (int)tabDescriptors.length);
    }

    public void test_enablesForFilter() {
        this.setSelection(new TreeNode[]{this.treeNodes[0], this.treeNodes[1]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageTest.assertEquals((String)"Information", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageTest.assertEquals((String)"Message", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageTest.assertEquals((int)2, (int)tabDescriptors.length);
    }

    public void test_sectionInformationTwoFilter() {
        this.setSelection(new TreeNode[]{this.treeNodes[1]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageTest.assertEquals((String)"Name", (String)tabDescriptors[0].getLabel());
        TabContents tabContents = this.testsView.getTabbedPropertySheetPage().getCurrentTab();
        ISection[] sections = tabContents.getSections();
        TabbedPropertySheetPageTest.assertEquals((int)2, (int)sections.length);
        TabbedPropertySheetPageTest.assertEquals(NameSection.class, sections[0].getClass());
        TabbedPropertySheetPageTest.assertEquals(InformationTwoSection.class, sections[1].getClass());
    }

    public void test_selectThreeMessageNodes() {
        this.setSelection(new TreeNode[]{this.treeNodes[1], this.treeNodes[2], this.treeNodes[3]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageTest.assertEquals((String)"Message", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageTest.assertEquals((int)1, (int)tabDescriptors.length);
    }

    public void test_widestLabelIndex1() {
        this.setSelection(new TreeNode[]{this.treeNodes[0]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageTest.assertEquals((String)"Name", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageTest.assertEquals((String)"Information", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageTest.assertEquals((String)"Message", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageTest.assertEquals((int)3, (int)tabDescriptors.length);
        TabbedPropertySheetPageTest.assertEquals((int)1, (int)((TabbedPropertyComposite)this.testsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    public void test_widestLabelIndex2() {
        this.setSelection(new TreeNode[]{this.treeNodes[2]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageTest.assertEquals((String)"Name", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageTest.assertEquals((String)"Error", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageTest.assertEquals((String)"Message", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageTest.assertEquals((int)3, (int)tabDescriptors.length);
        TabbedPropertySheetPageTest.assertEquals((int)2, (int)((TabbedPropertyComposite)this.testsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    public void test_widestLabelIndex3() {
        this.setSelection(new TreeNode[]{this.treeNodes[3]});
        ITabDescriptor[] tabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageTest.assertEquals((String)"Name", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageTest.assertEquals((String)"Warning", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageTest.assertEquals((String)"Message", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageTest.assertEquals((int)3, (int)tabDescriptors.length);
        TabbedPropertySheetPageTest.assertEquals((int)1, (int)((TabbedPropertyComposite)this.testsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    public void test_selectThreeResourceNodes() {
        this.setSelection(new TreeNode[]{this.treeNodes[5], this.treeNodes[6], this.treeNodes[7]});
        ITabDescriptor[] TabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageTest.assertEquals((String)"Resource", (String)TabDescriptors[0].getLabel());
        TabbedPropertySheetPageTest.assertEquals((int)1, (int)TabDescriptors.length);
    }

    public void test_noPropertiesAvailable() {
        TabContents tabContents = this.testsView.getTabbedPropertySheetPage().getCurrentTab();
        TabbedPropertySheetPageTest.assertNull((Object)tabContents);
        ITabDescriptor[] TabDescriptors = this.testsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageTest.assertEquals((int)0, (int)TabDescriptors.length);
        TabbedPropertySheetPageTest.assertEquals((int)-1, (int)((TabbedPropertyComposite)this.testsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }
}

