/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed.dynamic.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.tests.views.properties.tabbed.Activator;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.model.DynamicTestsColor;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.model.DynamicTestsShape;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsView;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class DynamicTestsElement
implements ITabbedPropertySheetPageContributor,
IPropertySource {
    public static String ADVANCED_CATEGORY = "Advanced";
    public static String DEFAULT_CATEGORY = "Default";
    public static String ID_COLOR = "Color";
    public static String ID_IMAGE = "Image";
    public static String ID_NAME = "Name";
    public static String ID_SHAPE = "Shape";
    private DynamicTestsColor dynamicTestsColor;
    private Image image;
    private String name;
    private String path;
    private List propertyDescriptors = new ArrayList();
    private DynamicTestsShape shape;
    private DynamicTestsView view;

    public DynamicTestsElement(DynamicTestsView aView, String aPath) {
        this.view = aView;
        this.path = aPath;
        int slash = this.path.indexOf(47);
        Assert.isTrue((slash > 0 ? 1 : 0) != 0);
        int underscore = this.path.indexOf(95);
        Assert.isTrue((underscore > 0 ? 1 : 0) != 0);
        int dot = this.path.indexOf(46);
        Assert.isTrue((dot > 0 ? 1 : 0) != 0);
        this.shape = DynamicTestsShape.getShape(this.path.substring(underscore + 1, dot));
        this.dynamicTestsColor = DynamicTestsColor.getColor(this.path.substring(slash + 1, underscore));
        this.image = Activator.getImageDescriptor(this.path).createImage();
        StringBuffer nameBuffer = new StringBuffer(this.path);
        nameBuffer.replace(slash + 1, slash + 2, this.path.substring(slash + 1, slash + 2).toUpperCase());
        nameBuffer.replace(underscore + 1, underscore + 2, this.path.substring(underscore + 1, underscore + 2).toUpperCase());
        nameBuffer.replace(underscore, underscore + 1, " ");
        this.name = nameBuffer.substring(slash + 1, dot).toString();
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor((Object)ID_NAME, ID_NAME);
        propertyDescriptor.setCategory(DEFAULT_CATEGORY);
        this.propertyDescriptors.add(propertyDescriptor);
        propertyDescriptor = new PropertyDescriptor((Object)ID_COLOR, ID_COLOR);
        propertyDescriptor.setCategory(DEFAULT_CATEGORY);
        this.propertyDescriptors.add(propertyDescriptor);
        propertyDescriptor = new PropertyDescriptor((Object)ID_SHAPE, ID_SHAPE);
        propertyDescriptor.setCategory(DEFAULT_CATEGORY);
        this.propertyDescriptors.add(propertyDescriptor);
        propertyDescriptor = new PropertyDescriptor((Object)ID_IMAGE, ID_IMAGE);
        propertyDescriptor.setCategory(ADVANCED_CATEGORY);
        this.propertyDescriptors.add(propertyDescriptor);
    }

    public String getContributorId() {
        return this.view.getContributorId();
    }

    public Object getEditableValue() {
        return this;
    }

    public Image getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(ID_COLOR)) {
            return this.dynamicTestsColor;
        }
        if (id.equals(ID_SHAPE)) {
            return this.shape;
        }
        if (id.equals(ID_NAME)) {
            return this.name;
        }
        if (id.equals(ID_IMAGE)) {
            return this.path;
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

