/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed.override.folders;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.tests.views.properties.tabbed.model.Element;
import org.eclipse.ui.tests.views.properties.tabbed.override.folders.IOverrideTestsTabFolder;
import org.eclipse.ui.tests.views.properties.tabbed.override.folders.IOverrideTestsTabItemSelectionListener;
import org.eclipse.ui.tests.views.properties.tabbed.override.items.IOverrideTestsItem;

public abstract class AbstractTabFolder
implements IOverrideTestsTabFolder {
    private ListenerList itemSelectionListeners = new ListenerList();
    private CTabFolder tabFolder;

    @Override
    public void addItemSelectionListener(IOverrideTestsTabItemSelectionListener listener) {
        this.itemSelectionListeners.add((Object)listener);
    }

    @Override
    public boolean appliesTo(Element element) {
        return false;
    }

    @Override
    public void createControls(Composite composite) {
        this.tabFolder = new CTabFolder(composite, 0);
        IOverrideTestsItem[] items = this.getItem();
        int i = 0;
        while (i < items.length) {
            CTabItem tabItem = new CTabItem(this.tabFolder, 0);
            items[i].createControls((Composite)this.tabFolder);
            tabItem.setText(items[i].getText());
            tabItem.setImage(items[i].getImage());
            tabItem.setControl((Control)items[i].getComposite());
            tabItem.setData((Object)items[i]);
            ++i;
        }
        this.tabFolder.setSelection(0);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem aTabItem = (CTabItem)e.item;
                Object[] listeners = AbstractTabFolder.this.itemSelectionListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    IOverrideTestsTabItemSelectionListener listener = (IOverrideTestsTabItemSelectionListener)listeners[i];
                    listener.itemSelected((IOverrideTestsItem)aTabItem.getData());
                    ++i;
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.tabFolder.dispose();
    }

    @Override
    public void removeItemSelectionListener(IOverrideTestsTabItemSelectionListener listener) {
        this.itemSelectionListeners.remove((Object)listener);
    }

    @Override
    public void selectionChanged(Element element) {
        CTabItem[] items = this.tabFolder.getItems();
        int i = 0;
        while (i < items.length) {
            CTabItem tabItem = items[i];
            if (((IOverrideTestsItem)tabItem.getData()).getText().equals(element.getName())) {
                this.tabFolder.setSelection(tabItem);
            }
            ++i;
        }
    }
}

