/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests;

import java.util.ResourceBundle;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.workbench.texteditor.tests.ScreenshotTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class FindReplaceDialogTest {
    @Rule
    public TestName testName = new TestName();
    private Accessor fFindReplaceDialog;
    private TextViewer fTextViewer;

    private void runEventQueue() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        int i = 0;
        while (i < 10) {
            while (display.readAndDispatch()) {
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
    }

    private void openFindReplaceDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.fFindReplaceDialog = new Accessor("org.eclipse.ui.texteditor.FindReplaceDialog", this.getClass().getClassLoader(), new Object[]{shell});
        this.fFindReplaceDialog.invoke("create", null);
    }

    private void openTextViewerAndFindReplaceDialog() {
        this.fTextViewer = new TextViewer((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 2816);
        this.fTextViewer.setDocument((IDocument)new Document("line\nline\nline"));
        this.fTextViewer.getControl().setFocus();
        Accessor fFindReplaceAction = new Accessor("org.eclipse.ui.texteditor.FindReplaceAction", this.getClass().getClassLoader(), new Class[]{ResourceBundle.class, String.class, Shell.class, IFindReplaceTarget.class}, new Object[]{ResourceBundle.getBundle("org.eclipse.ui.texteditor.ConstructedEditorMessages"), "Editor.FindReplace.", this.fTextViewer.getControl().getShell(), this.fTextViewer.getFindReplaceTarget()});
        fFindReplaceAction.invoke("run", null);
        Object fFindReplaceDialogStub = fFindReplaceAction.get("fgFindReplaceDialogStub");
        if (fFindReplaceDialogStub == null) {
            fFindReplaceDialogStub = fFindReplaceAction.get("fgFindReplaceDialogStubShell");
        }
        Accessor fFindReplaceDialogStubAccessor = new Accessor(fFindReplaceDialogStub, "org.eclipse.ui.texteditor.FindReplaceAction$FindReplaceDialogStub", this.getClass().getClassLoader());
        this.fFindReplaceDialog = new Accessor(fFindReplaceDialogStubAccessor.invoke("getDialog", null), "org.eclipse.ui.texteditor.FindReplaceDialog", this.getClass().getClassLoader());
    }

    @After
    public void tearDown() throws Exception {
        if (this.fFindReplaceDialog != null) {
            this.fFindReplaceDialog.invoke("close", null);
            this.fFindReplaceDialog = null;
        }
        if (this.fTextViewer != null) {
            this.fTextViewer.getControl().dispose();
            this.fTextViewer = null;
        }
    }

    @Test
    public void test01InitialButtonState() {
        this.openFindReplaceDialog();
        Boolean value = (Boolean)this.fFindReplaceDialog.invoke("isWholeWordSearch", null);
        Assert.assertFalse((boolean)value);
        value = (Boolean)this.fFindReplaceDialog.invoke("isWholeWordSetting", null);
        Assert.assertFalse((boolean)value);
        value = (Boolean)this.fFindReplaceDialog.invoke("isWrapSearch", null);
        Assert.assertTrue((boolean)value);
        value = (Boolean)this.fFindReplaceDialog.invoke("isRegExSearch", null);
        Assert.assertFalse((boolean)value);
        value = (Boolean)this.fFindReplaceDialog.invoke("isRegExSearchAvailableAndChecked", null);
        Assert.assertFalse((boolean)value);
        Button checkbox = (Button)this.fFindReplaceDialog.get("fIsRegExCheckBox");
        Assert.assertTrue((boolean)checkbox.isEnabled());
        checkbox = (Button)this.fFindReplaceDialog.get("fWholeWordCheckBox");
        Assert.assertFalse((boolean)checkbox.isEnabled());
    }

    @Test
    public void testDisableWholeWordIfRegEx() {
        this.openFindReplaceDialog();
        Combo findField = (Combo)this.fFindReplaceDialog.get("fFindField");
        findField.setText("word");
        Button isRegExCheckBox = (Button)this.fFindReplaceDialog.get("fIsRegExCheckBox");
        Button wholeWordCheckbox = (Button)this.fFindReplaceDialog.get("fWholeWordCheckBox");
        Assert.assertTrue((boolean)isRegExCheckBox.isEnabled());
        Assert.assertTrue((boolean)wholeWordCheckbox.isEnabled());
        this.fFindReplaceDialog.set("fIsTargetSupportingRegEx", true);
        isRegExCheckBox.setSelection(true);
        wholeWordCheckbox.setSelection(true);
        this.fFindReplaceDialog.invoke("updateButtonState", null);
        Assert.assertTrue((boolean)isRegExCheckBox.isEnabled());
        Assert.assertFalse((boolean)wholeWordCheckbox.isEnabled());
        Assert.assertTrue((boolean)wholeWordCheckbox.getSelection());
    }

    @Test
    public void testDisableWholeWordIfNotWord() {
        this.openFindReplaceDialog();
        Combo findField = (Combo)this.fFindReplaceDialog.get("fFindField");
        Button isRegExCheckBox = (Button)this.fFindReplaceDialog.get("fIsRegExCheckBox");
        Button wholeWordCheckbox = (Button)this.fFindReplaceDialog.get("fWholeWordCheckBox");
        this.fFindReplaceDialog.set("fIsTargetSupportingRegEx", false);
        isRegExCheckBox.setSelection(false);
        wholeWordCheckbox.setSelection(true);
        this.fFindReplaceDialog.invoke("updateButtonState", null);
        findField.setText("word");
        Assert.assertTrue((boolean)isRegExCheckBox.isEnabled());
        Assert.assertTrue((boolean)wholeWordCheckbox.isEnabled());
        Assert.assertTrue((boolean)wholeWordCheckbox.getSelection());
        findField.setText("no word");
        Assert.assertTrue((boolean)isRegExCheckBox.isEnabled());
        Assert.assertFalse((boolean)wholeWordCheckbox.isEnabled());
        Assert.assertTrue((boolean)wholeWordCheckbox.getSelection());
    }

    @Test
    public void testFocusNotChangedWhenEnterPressed() {
        this.openTextViewerAndFindReplaceDialog();
        Combo findField = (Combo)this.fFindReplaceDialog.get("fFindField");
        findField.setFocus();
        findField.setText("line");
        Event event = new Event();
        event.type = 31;
        event.detail = 4;
        event.character = (char)13;
        event.doit = true;
        findField.traverse(4, event);
        this.runEventQueue();
        Shell shell = (Shell)this.fFindReplaceDialog.get("fActiveShell");
        if (shell == null && Util.isGtk()) {
            if (ScreenshotTest.isRunByGerritHudsonJob()) {
                this.takeScreenshot();
                return;
            }
            Assert.fail((String)("this test does not work on GTK unless the runtime workbench has focus. Screenshot: " + this.takeScreenshot()));
        }
        Assert.assertTrue((boolean)findField.isFocusControl());
        if (Util.isMac()) {
            return;
        }
        Button wrapSearchBox = (Button)this.fFindReplaceDialog.get("fWrapCheckBox");
        wrapSearchBox.setFocus();
        event.doit = true;
        findField.traverse(4, event);
        this.runEventQueue();
        Assert.assertTrue((boolean)wrapSearchBox.isFocusControl());
        Button allScopeBox = (Button)this.fFindReplaceDialog.get("fGlobalRadioButton");
        allScopeBox.setFocus();
        event.doit = true;
        findField.traverse(4, event);
        this.runEventQueue();
        Assert.assertTrue((boolean)allScopeBox.isFocusControl());
    }

    private String takeScreenshot() {
        return ScreenshotTest.takeScreenshot(FindReplaceDialogTest.class, this.testName.getMethodName(), System.out);
    }

    @Test
    public void testFocusNotChangedWhenButtonMnemonicPressed() {
        if (Util.isMac()) {
            return;
        }
        this.openTextViewerAndFindReplaceDialog();
        Combo findField = (Combo)this.fFindReplaceDialog.get("fFindField");
        findField.setText("line");
        Event event = new Event();
        this.runEventQueue();
        Shell shell = (Shell)this.fFindReplaceDialog.get("fActiveShell");
        if (shell == null && Util.isGtk()) {
            if (ScreenshotTest.isRunByGerritHudsonJob()) {
                this.takeScreenshot();
                return;
            }
            Assert.fail((String)("this test does not work on GTK unless the runtime workbench has focus. Screenshot: " + this.takeScreenshot()));
        }
        Button wrapSearchBox = (Button)this.fFindReplaceDialog.get("fWrapCheckBox");
        wrapSearchBox.setFocus();
        event.detail = 128;
        event.character = (char)110;
        event.doit = false;
        wrapSearchBox.traverse(128, event);
        this.runEventQueue();
        Assert.assertTrue((boolean)wrapSearchBox.isFocusControl());
        Button allScopeBox = (Button)this.fFindReplaceDialog.get("fGlobalRadioButton");
        allScopeBox.setFocus();
        event.detail = 128;
        event.doit = false;
        allScopeBox.traverse(128, event);
        this.runEventQueue();
        Assert.assertTrue((boolean)allScopeBox.isFocusControl());
        event.detail = 128;
        event.character = (char)114;
        event.doit = false;
        allScopeBox.traverse(128, event);
        this.runEventQueue();
        Assert.assertTrue((boolean)allScopeBox.isFocusControl());
    }

    @Test
    public void testShiftEnterReversesSearchDirection() {
        this.openTextViewerAndFindReplaceDialog();
        Combo findField = (Combo)this.fFindReplaceDialog.get("fFindField");
        findField.setText("line");
        IFindReplaceTarget target = (IFindReplaceTarget)this.fFindReplaceDialog.get("fTarget");
        this.runEventQueue();
        Shell shell = (Shell)this.fFindReplaceDialog.get("fActiveShell");
        if (shell == null && Util.isGtk()) {
            if (ScreenshotTest.isRunByGerritHudsonJob()) {
                this.takeScreenshot();
                return;
            }
            Assert.fail((String)("this test does not work on GTK unless the runtime workbench has focus. Screenshot: " + this.takeScreenshot()));
        }
        Event event = new Event();
        event.detail = 4;
        event.character = (char)13;
        findField.traverse(4, event);
        this.runEventQueue();
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        event.doit = true;
        findField.traverse(4, event);
        this.runEventQueue();
        Assert.assertEquals((long)5L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        event.stateMask = 131072;
        event.doit = true;
        findField.traverse(4, event);
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        Button forwardRadioButton = (Button)this.fFindReplaceDialog.get("fForwardRadioButton");
        forwardRadioButton.setSelection(false);
        event.doit = true;
        forwardRadioButton.traverse(4, event);
        Assert.assertEquals((long)5L, (long)target.getSelection().x);
    }
}

