/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.internal.texteditor.HippieCompletionEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HippieCompletionTest {
    IDocument[] documents;
    private HippieCompletionEngine fEngine;

    @Before
    public void setUp() throws Exception {
        this.documents = new IDocument[5];
        this.documents[0] = new Document("package ui.TestPackage;\n\n/**\n * This is a testing class that tests the hippie completion engine.\n * it has a simple main with a print method\n */\npublic class TestClass1 {\n\n    public static void main(String[] args) {\n        System.out.println(\"I will be printing Hello world!\");\n    }\n}");
        this.documents[1] = new Document("This is a simple text file\nwith some testssome test that is also used in the completion engine tests");
        this.documents[2] = new Document("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<plugin\n   id=\"org.eclipse.ui.workbench.texteditor.tests\"\n   name=\"%Plugin.name\"\n   version=\"3.1.0\"\n   provider-name=\"%Plugin.providerName\">\n\n   <runtime>\n      <library name=\"workbenchtexteditortests.jar\">\n         <export name=\"*\"/>\n      </library>\n   </runtime>\n   \n   <requires>\n      <import plugin=\"org.eclipse.core.runtime.compatibility\"/>\n      <import plugin=\"org.junit\"/>\n      <import plugin=\"org.eclipse.text.tests\"/>\n      <import plugin=\"org.eclipse.jface.text\"/>\n      <import plugin=\"org.eclipse.ui.workbench.texteditor\"/>\n      <import plugin=\"org.eclipse.ui\"/>\n   </requires>\n   \n</plugin>\n");
        this.documents[3] = new Document("###############################################################################\n# Copyright (c) 2000, 2004 IBM Corporation and others.\n# All rights reserved. This program and the accompanying materials \n# are made available under the terms of the Eclipse Public License v1.0\n# which accompanies this distribution, and is available at\n# http://www.eclipse.org/legal/epl-v10.html\n# \n# Contributors:\n#     IBM Corporation - initial API and implementation\n###############################################################################\nbin.includes= plugin.xml,\\\n               plugin.properties,\\\n               test.xml,\\\n               about.html,\\\n               *.jar\n\nsrc.includes= about.html\n               \nsource.workbenchtexteditortests.jar= src/\n");
        this.documents[4] = new Document("/**\n * This class tests the hippie completion functionality.\n * \u05d4\u05de\u05d7\u05dc\u05e7\u05d4 \u05d4\u05d6\u05d5 \u05d1\u05d5\u05d3\u05e7\u05ea \u05d0\u05ea \u05de\u05e0\u05d2\u05e0\u05d5\u05df \u05d4\u05d4\u05e9\u05dc\u05de\u05d5\u05ea\n * This is an arabic word - \u0647\u0630\u0627 \u0643\u0644\u0645\u0629 \u0639\u0631\u0628\u064a\u0651\u0629\n * Eclipse is the best IDE - Eclipse \u044d\u0442\u043e \u0441\u0430\u043c\u044b\u0439 \u043b\u0443\u0447\u0448\u0438\u0439 IDE.\n */\n\npublic class HippieTester2 {\n\n\tpublic static void main(String[] args) {\n\t\tchar \u05de\u05d7= '9';\n\t\tString $arabic\u20acDigits= \"\u0661\u0662\u0663\u0664\u0665\u0666\u2021\u0667\u0668\u0669\u0660\";\n\t\tString $arabic\u20aaWord= \"\u0628\u064e\u0627\u0628\u0650\";\n\t\tString \u0628\u0627\u0628= \"\u044d\u0442\";\n\t\tint \u20a31= 3;\n\t\tint \u00a3\u0661\u0662\u0663= \u20a31 + \u05de\u05d7;\n\t\tint a\u0300\u0301b= 18;\n\t\t}\n\t\t\n\tpublic void \u05d4\u05d4\u05e9(int \u0441\u0430\u043c) {\n\t\tString \u043b\u0443\u0447\u0448= \"\u05d1\u05d5\u05d3\u05e7\";\n\t\tchar \u20aa129;\n\t}\n}");
        this.fEngine = new HippieCompletionEngine();
    }

    @Test
    public void testSearchBackwards1() {
        try {
            List list = this.fEngine.getCompletionsBackwards(this.documents[0], (CharSequence)"pri", this.documents[0].get().indexOf("println") + 10);
            Assert.assertEquals((long)list.size(), (long)2L);
            Assert.assertEquals(list.get(0), (Object)"ntln");
            Assert.assertEquals(list.get(1), (Object)"nt");
            list = this.fEngine.getCompletionsBackwards(this.documents[0], (CharSequence)"pri", this.documents[0].getLength());
            Assert.assertEquals((long)list.size(), (long)3L);
            Assert.assertEquals(list.get(0), (Object)"nting");
            Assert.assertEquals(list.get(1), (Object)"ntln");
            Assert.assertEquals(list.get(2), (Object)"nt");
            list = this.fEngine.getCompletionsBackwards(this.documents[0], (CharSequence)"pri", this.documents[0].get().indexOf("println") + 1);
            Assert.assertEquals((long)list.size(), (long)1L);
            Assert.assertEquals(list.get(0), (Object)"nt");
            list = this.fEngine.getCompletionsBackwards(this.documents[0], (CharSequence)"pa", 2);
            Assert.assertEquals((long)list.size(), (long)0L);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"Got out of document bounds", (boolean)false);
        }
    }

    @Test
    public void testSearchBackwards2() {
        try {
            List list = this.fEngine.getCompletionsBackwards(this.documents[2], (CharSequence)"plugi", this.documents[2].getLength());
            Assert.assertEquals((long)8L, (long)list.size());
            list = this.fEngine.makeUnique(list);
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"n", list.get(0));
            list = this.fEngine.getCompletionsBackwards(this.documents[2], (CharSequence)"plugin", this.documents[2].getLength());
            Assert.assertEquals((long)0L, (long)list.size());
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"Got out of document bounds", (boolean)false);
        }
    }

    @Test
    public void testSearchBackwards3() {
        try {
            List list = this.fEngine.getCompletionsBackwards(this.documents[1], (CharSequence)"test", this.documents[1].getLength());
            Assert.assertEquals((String)"Number of backwards suggestions does not match", (long)2L, (long)list.size());
            list = this.fEngine.getCompletionsBackwards(this.documents[1], (CharSequence)"tests", this.documents[1].getLength());
            Assert.assertEquals((String)"Number of backwards suggestions does not match", (long)1L, (long)list.size());
            list = this.fEngine.getCompletionsBackwards(this.documents[1], (CharSequence)"test", this.documents[1].getLength() - 1);
            Assert.assertEquals((String)"Number of backwards suggestions does not match", (long)1L, (long)list.size());
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"Got out of document bounds", (boolean)false);
        }
    }

    @Test
    public void testSearch() {
        ArrayList<IDocument> docsList = new ArrayList<IDocument>(Arrays.asList(this.documents));
        List result = this.createSuggestions("te", docsList);
        Assert.assertEquals((String)"Number of completions does not match", (long)15L, (long)result.size());
        result = this.fEngine.makeUnique(result);
        Assert.assertEquals((String)"Number of completions does not match", (long)7L, (long)result.size());
        result = this.createSuggestions("Plug", docsList);
        Assert.assertEquals((String)"Number of completions does not match", (long)2L, (long)result.size());
        result = this.createSuggestions("p", docsList);
        Assert.assertEquals((String)"Number of completions does not match", (long)23L, (long)result.size());
        result = this.fEngine.makeUnique(result);
        Assert.assertEquals((String)"Number of completions does not match", (long)10L, (long)result.size());
        Assert.assertEquals((String)"Incorrect completion", (Object)"ackage", result.get(0));
        Assert.assertEquals((String)"Incorrect completion", (Object)"rint", result.get(1));
        Assert.assertEquals((String)"Incorrect completion", (Object)"ublic", result.get(2));
        Assert.assertEquals((String)"Incorrect completion", (Object)"rintln", result.get(3));
        Assert.assertEquals((String)"Incorrect completion", (Object)"rinting", result.get(4));
        Assert.assertEquals((String)"Incorrect completion", (Object)"lugin", result.get(5));
        Assert.assertEquals((String)"Incorrect completion", (Object)"rovider", result.get(6));
        Assert.assertEquals((String)"Incorrect completion", (Object)"roviderName", result.get(7));
        Assert.assertEquals((String)"Incorrect completion", (Object)"rogram", result.get(8));
        Assert.assertEquals((String)"Incorrect completion", (Object)"roperties", result.get(9));
    }

    @Test
    public void testSearch2() {
        ArrayList<IDocument> docsList = new ArrayList<IDocument>(Arrays.asList(this.documents));
        List<String> result = this.createSuggestions("printe", docsList);
        Assert.assertEquals((String)"Number of completions does not match", (long)0L, (long)result.size());
        result = this.createSuggestions("s", docsList);
        Assert.assertEquals((String)"Number of completions does not match", (long)8L, (long)result.size());
        result = this.createSuggestions("pack", this.documents[0]);
        Assert.assertEquals((String)"Number of completions does not match", (long)1L, (long)result.size());
    }

    @Test
    public void testForwardSearch() {
        try {
            List result = this.fEngine.getCompletionsForward(this.documents[0], (CharSequence)"cl", this.documents[0].get().indexOf("cl"), true);
            Assert.assertEquals((long)2L, (long)result.size());
            result = this.fEngine.getCompletionsForward(this.documents[0], (CharSequence)"cl", this.documents[0].get().indexOf("cl") + 1, true);
            Assert.assertEquals((long)1L, (long)result.size());
            result = this.fEngine.getCompletionsForward(this.documents[1], (CharSequence)"Thi", 0, true);
            Assert.assertEquals((long)1L, (long)result.size());
            result = this.fEngine.getCompletionsForward(this.documents[1], (CharSequence)"Thi", 1, true);
            Assert.assertEquals((long)0L, (long)result.size());
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"Got out of document bounds", (boolean)false);
        }
    }

    @Test
    public void testForwardSearchInternational() {
        try {
            List result = this.fEngine.getCompletionsForward(this.documents[4], (CharSequence)"$", this.documents[4].get().indexOf(36), true);
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)"arabic\u20aaWord", result.get(0));
            Assert.assertEquals((Object)"arabic\u20acDigits", result.get(1));
            result = this.fEngine.getCompletionsForward(this.documents[4], (CharSequence)"$", this.documents[4].get().indexOf(36), false);
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)"arabic\u20acDigits", result.get(0));
            Assert.assertEquals((Object)"arabic\u20aaWord", result.get(1));
            result = this.fEngine.getCompletionsForward(this.documents[4], (CharSequence)"$", this.documents[4].get().indexOf(36) + 1, true);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"arabic\u20aaWord", result.get(0));
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"Got out of document bounds", (boolean)false);
        }
    }

    @Test
    public void testPrefix() {
        try {
            String prefix = this.fEngine.getPrefixString(this.documents[0], this.documents[0].get().indexOf("testing") + 3);
            Assert.assertEquals((Object)prefix, (Object)"tes");
            prefix = this.fEngine.getPrefixString(this.documents[0], this.documents[0].get().indexOf("public") + 4);
            Assert.assertEquals((Object)prefix, (Object)"publ");
            prefix = this.fEngine.getPrefixString(this.documents[0], this.documents[0].get().indexOf("println") + 7);
            Assert.assertEquals((Object)prefix, (Object)"println");
            prefix = this.fEngine.getPrefixString(this.documents[0], this.documents[0].get().indexOf("println") + 8);
            Assert.assertEquals((Object)prefix, null);
            prefix = this.fEngine.getPrefixString(this.documents[1], 3);
            Assert.assertEquals((Object)prefix, (Object)"Thi");
            prefix = this.fEngine.getPrefixString(this.documents[1], 0);
            Assert.assertEquals((Object)prefix, null);
            prefix = this.fEngine.getPrefixString(this.documents[1], this.documents[1].getLength());
            Assert.assertEquals((Object)prefix, (Object)"tests");
            prefix = this.fEngine.getPrefixString(this.documents[3], this.documents[3].get().indexOf("Copyright") - 2);
            Assert.assertEquals((Object)prefix, null);
            prefix = this.fEngine.getPrefixString(this.documents[4], this.documents[4].get().indexOf("IDE") + 2);
            Assert.assertEquals((Object)prefix, (Object)"ID");
            prefix = this.fEngine.getPrefixString(this.documents[4], this.documents[4].get().indexOf("$arabic\u20acDigits") + 8);
            Assert.assertEquals((Object)prefix, (Object)"$arabic\u20ac");
            prefix = this.fEngine.getPrefixString(this.documents[4], this.documents[4].get().indexOf("$arabic\u20aaWord") + 8);
            Assert.assertEquals((Object)prefix, (Object)"$arabic\u20aa");
            prefix = this.fEngine.getPrefixString(this.documents[4], this.documents[4].get().indexOf("\u00a3\u0661\u0662\u0663") + 3);
            Assert.assertEquals((Object)prefix, (Object)"\u00a3\u0661\u0662");
            prefix = this.fEngine.getPrefixString(this.documents[4], this.documents[4].get().indexOf("a\u0300\u0301b") + 3);
            Assert.assertEquals((Object)prefix, (Object)"a\u0300\u0301");
            prefix = this.fEngine.getPrefixString(this.documents[4], this.documents[4].get().indexOf("\u0667\u0668\u0669\u0660") + 2);
            Assert.assertEquals((Object)prefix, (Object)"\u0667\u0668");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"Got out of document bounds", (boolean)false);
        }
    }

    @Test
    public void testInternational() {
        IDocument intlDoc = this.documents[4];
        List<String> result = this.createSuggestions("\u05d4", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)4L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"\u05de\u05d7\u05dc\u05e7\u05d4");
        Assert.assertEquals((Object)result.get(1), (Object)"\u05d6\u05d5");
        Assert.assertEquals((Object)result.get(2), (Object)"\u05d4\u05e9\u05dc\u05de\u05d5\u05ea");
        Assert.assertEquals((Object)result.get(3), (Object)"\u05d4\u05e9");
        result = this.createSuggestions("\u0661", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)1L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"\u0662\u0663\u0664\u0665\u0666");
        result = this.createSuggestions("\u0628\u064e", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)1L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"\u0627\u0628\u0650");
        result = this.createSuggestions("\u0628", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)2L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"\u064e\u0627\u0628\u0650");
        Assert.assertEquals((Object)result.get(1), (Object)"\u0627\u0628");
        result = this.createSuggestions("$ara", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)2L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"bic\u20acDigits");
        Assert.assertEquals((Object)result.get(1), (Object)"bic\u20aaWord");
        result = this.createSuggestions("\u0441\u0430", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)2L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"\u043c\u044b\u0439");
        Assert.assertEquals((Object)result.get(1), (Object)"\u043c");
        result = this.createSuggestions("\u05d1\u05d5", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)2L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"\u05d3\u05e7\u05ea");
        Assert.assertEquals((Object)result.get(1), (Object)"\u05d3\u05e7");
        result = this.createSuggestions("a", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)4L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"n");
        Assert.assertEquals((Object)result.get(1), (Object)"rabic");
        Assert.assertEquals((Object)result.get(2), (Object)"rgs");
        Assert.assertEquals((Object)result.get(3), (Object)"\u0300\u0301b");
        result = this.createSuggestions("\u20aa", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)1L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"129");
        result = this.createSuggestions("\u20a3", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)2L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"1");
        Assert.assertEquals((Object)result.get(1), (Object)"1");
        result = this.createSuggestions("\u044d", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)2L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"\u0442\u043e");
        Assert.assertEquals((Object)result.get(1), (Object)"\u0442");
        result = this.createSuggestions("\u00a3", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)1L, (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"\u0661\u0662\u0663");
        result = this.createSuggestions("\u00a5", intlDoc);
        Assert.assertEquals((String)"Number of completions does not match", (long)0L, (long)result.size());
    }

    @Test
    public void testInternationalBackwards() {
        IDocument intlDoc = this.documents[4];
        try {
            List list = this.fEngine.getCompletionsBackwards(intlDoc, (CharSequence)"\u043b\u0443", intlDoc.get().indexOf("129"));
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals(list.get(0), (Object)"\u0447\u0448");
            Assert.assertEquals(list.get(1), (Object)"\u0447\u0448\u0438\u0439");
            list = this.fEngine.getCompletionsBackwards(intlDoc, (CharSequence)"\u05de", intlDoc.get().lastIndexOf(43));
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals(list.get(0), (Object)"\u05d7");
            Assert.assertEquals(list.get(1), (Object)"\u05e0\u05d2\u05e0\u05d5\u05df");
            list = this.fEngine.getCompletionsBackwards(intlDoc, (CharSequence)"\u0667", intlDoc.get().indexOf("\u2021\u0667") + 1);
            Assert.assertEquals((long)0L, (long)list.size());
            list = this.fEngine.getCompletionsBackwards(intlDoc, (CharSequence)"\u0628", intlDoc.get().lastIndexOf("\u0628"));
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals(list.get(0), (Object)"\u064e\u0627\u0628\u0650");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"Got out of document bounds", (boolean)false);
        }
    }

    private Accessor createAccessor(Iterator<String> suggestions, int startOffset) {
        return new Accessor("org.eclipse.ui.texteditor.HippieCompleteAction$CompletionState", this.getClass().getClassLoader(), new Class[]{Iterator.class, Integer.TYPE}, new Object[]{suggestions, startOffset});
    }

    private String next(Accessor state) {
        return (String)state.invoke("next", new Object[0]);
    }

    @Test
    public void testCompletionState() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Accessor state = null;
        try {
            state = this.createAccessor(list.iterator(), 0);
            Assert.fail((String)"Having no items is not valid (at least the empty completion must be there)");
        }
        catch (AssertionFailedException assertionFailedException) {}
        list.add("");
        state = this.createAccessor(list.iterator(), 0);
        Assert.assertTrue((boolean)state.getBoolean("hasOnly1EmptySuggestion"));
        int i = 0;
        while (i < 3) {
            Assert.assertEquals((Object)"", (Object)this.next(state));
            ++i;
        }
        list.add("");
        state = this.createAccessor(list.iterator(), 0);
        Assert.assertTrue((boolean)state.getBoolean("hasOnly1EmptySuggestion"));
        i = 0;
        while (i < 3) {
            Assert.assertEquals((Object)"", (Object)this.next(state));
            ++i;
        }
        list.add(0, "aaaa");
        state = this.createAccessor(list.iterator(), 0);
        Assert.assertFalse((boolean)state.getBoolean("hasOnly1EmptySuggestion"));
        i = 0;
        while (i < 3) {
            Assert.assertEquals((Object)"aaaa", (Object)this.next(state));
            Assert.assertEquals((Object)"", (Object)this.next(state));
            ++i;
        }
        list.add(1, "bbbb");
        state = this.createAccessor(list.iterator(), 0);
        Assert.assertFalse((boolean)state.getBoolean("hasOnly1EmptySuggestion"));
        i = 0;
        while (i < 3) {
            Assert.assertEquals((Object)"aaaa", (Object)this.next(state));
            Assert.assertEquals((Object)"bbbb", (Object)this.next(state));
            Assert.assertEquals((Object)"", (Object)this.next(state));
            ++i;
        }
        list.add(2, "bbbb");
        state = this.createAccessor(list.iterator(), 0);
        Assert.assertFalse((boolean)state.getBoolean("hasOnly1EmptySuggestion"));
        i = 0;
        while (i < 3) {
            Assert.assertEquals((Object)"aaaa", (Object)this.next(state));
            Assert.assertEquals((Object)"bbbb", (Object)this.next(state));
            Assert.assertEquals((Object)"", (Object)this.next(state));
            ++i;
        }
    }

    @Test
    public void testIteration() throws Exception {
        Document openDocument = new Document("bar\nbar1\nbar2\n");
        Iterator suggestions = this.fEngine.getMultipleDocumentsIterator((IDocument)openDocument, new ArrayList(), (CharSequence)"bar", 3);
        Assert.assertEquals((Object)"1", suggestions.next());
        Assert.assertEquals((Object)"2", suggestions.next());
        Assert.assertEquals((Object)"", suggestions.next());
        Assert.assertFalse((boolean)suggestions.hasNext());
        ArrayList<Document> otherDocuments = new ArrayList<Document>();
        otherDocuments.add(new Document("bar3\nbar4\n"));
        suggestions = this.fEngine.getMultipleDocumentsIterator((IDocument)openDocument, otherDocuments, (CharSequence)"bar", 3);
        Assert.assertEquals((Object)"1", suggestions.next());
        Assert.assertEquals((Object)"2", suggestions.next());
        Assert.assertEquals((Object)"3", suggestions.next());
        Assert.assertEquals((Object)"4", suggestions.next());
        Assert.assertEquals((Object)"", suggestions.next());
        Assert.assertFalse((boolean)suggestions.hasNext());
        suggestions = this.fEngine.getMultipleDocumentsIterator((IDocument)openDocument, otherDocuments, (CharSequence)"bar", 3);
        otherDocuments.add(new Document());
        otherDocuments.add(new Document("bar3\nbar4\n"));
        Assert.assertEquals((Object)"1", suggestions.next());
        Assert.assertEquals((Object)"2", suggestions.next());
        Assert.assertEquals((Object)"3", suggestions.next());
        Assert.assertEquals((Object)"4", suggestions.next());
        Assert.assertEquals((Object)"3", suggestions.next());
        Assert.assertEquals((Object)"4", suggestions.next());
        Assert.assertEquals((Object)"", suggestions.next());
        Assert.assertFalse((boolean)suggestions.hasNext());
        openDocument = new Document("bar0 bar1 bar");
        suggestions = this.fEngine.getMultipleDocumentsIterator((IDocument)openDocument, new ArrayList(), (CharSequence)"bar", openDocument.getLength());
        Assert.assertEquals((Object)"1", suggestions.next());
        Assert.assertEquals((Object)"0", suggestions.next());
        Assert.assertEquals((Object)"", suggestions.next());
        Assert.assertFalse((boolean)suggestions.hasNext());
    }

    private List<String> createSuggestions(String prefix, IDocument doc) {
        return this.createSuggestions(prefix, Arrays.asList(doc));
    }

    private List<String> createSuggestions(String prefix, List<IDocument> docsList) {
        ArrayList<String> results = new ArrayList<String>();
        for (IDocument doc : docsList) {
            try {
                results.addAll(this.fEngine.getCompletionsForward(doc, (CharSequence)prefix, 0, false));
            }
            catch (BadLocationException badLocationException) {
                Assert.assertTrue((String)"No exception should be thrown here", (boolean)false);
            }
        }
        return results;
    }
}

