/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests.revisions;

import org.eclipse.jface.internal.text.revisions.LineIndexOutOfBoundsException;
import org.eclipse.jface.internal.text.revisions.Range;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.junit.Assert;
import org.junit.Test;

public class RangeTest {
    @Test
    public void testLegalOperations() {
        Range r = Range.createRelative((int)0, (int)1);
        Assert.assertEquals((long)0L, (long)r.start());
        Assert.assertEquals((long)1L, (long)r.length());
        RangeTest.assertConsistency(r);
        r = Range.createAbsolute((int)5, (int)6);
        Assert.assertEquals((long)5L, (long)r.start());
        Assert.assertEquals((long)1L, (long)r.length());
        RangeTest.assertConsistency(r);
        r = Range.copy((ILineRange)new LineRange(5, 1));
        Assert.assertEquals((long)5L, (long)r.start());
        Assert.assertEquals((long)1L, (long)r.length());
        RangeTest.assertConsistency(r);
        r = Range.createRelative((int)5, (int)1);
        Assert.assertEquals((long)5L, (long)r.start());
        Assert.assertEquals((long)1L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.moveBy(10);
        Assert.assertEquals((long)15L, (long)r.start());
        Assert.assertEquals((long)1L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.moveBy(-8);
        Assert.assertEquals((long)7L, (long)r.start());
        Assert.assertEquals((long)1L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.moveTo(12);
        Assert.assertEquals((long)12L, (long)r.start());
        Assert.assertEquals((long)1L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.resizeBy(4);
        Assert.assertEquals((long)12L, (long)r.start());
        Assert.assertEquals((long)5L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.resizeAndMoveBy(3);
        Assert.assertEquals((long)15L, (long)r.start());
        Assert.assertEquals((long)2L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.resizeAndMoveBy(-3);
        Assert.assertEquals((long)12L, (long)r.start());
        Assert.assertEquals((long)5L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.setLength(3);
        Assert.assertEquals((long)12L, (long)r.start());
        Assert.assertEquals((long)3L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.resizeBy(13);
        Assert.assertEquals((long)12L, (long)r.start());
        Assert.assertEquals((long)16L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.resizeBy(-4);
        Assert.assertEquals((long)12L, (long)r.start());
        Assert.assertEquals((long)12L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.setEnd(18);
        Assert.assertEquals((long)12L, (long)r.start());
        Assert.assertEquals((long)6L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.moveEndTo(13);
        Assert.assertEquals((long)7L, (long)r.start());
        Assert.assertEquals((long)6L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.setLengthAndMove(3);
        Assert.assertEquals((long)10L, (long)r.start());
        Assert.assertEquals((long)3L, (long)r.length());
        RangeTest.assertConsistency(r);
        r.setStart(7);
        Assert.assertEquals((long)7L, (long)r.start());
        Assert.assertEquals((long)6L, (long)r.length());
        RangeTest.assertConsistency(r);
    }

    @Test
    public void testSplit() throws Exception {
        Range r = Range.createRelative((int)12, (int)18);
        Range second = r.split(8);
        Assert.assertEquals((long)12L, (long)r.start());
        Assert.assertEquals((long)8L, (long)r.length());
        RangeTest.assertConsistency(r);
        Assert.assertEquals((long)20L, (long)second.start());
        Assert.assertEquals((long)10L, (long)second.length());
        RangeTest.assertConsistency(second);
    }

    @Test
    public void testIllegalOperations() throws Exception {
        try {
            Range.copy(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {}
        try {
            Range.createRelative((int)0, (int)0);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        try {
            Range.createRelative((int)0, (int)-1);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        try {
            Range.createRelative((int)-1, (int)0);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        try {
            Range.createRelative((int)-1, (int)-1);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        try {
            Range.createAbsolute((int)0, (int)0);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        try {
            Range.createAbsolute((int)0, (int)-1);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        try {
            Range.createAbsolute((int)-1, (int)0);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        try {
            Range.createAbsolute((int)-1, (int)12);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        try {
            Range.createAbsolute((int)10, (int)10);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        try {
            Range.createAbsolute((int)12, (int)10);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        try {
            Range.createAbsolute((int)12, (int)-3);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {}
        Range r = Range.createRelative((int)5, (int)10);
        try {
            r.moveBy(-6);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        r.moveBy(-4);
        try {
            r.moveBy(-2);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            r.moveBy(4);
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.resizeBy(-11);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.resizeAndMoveBy(-6);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.resizeAndMoveBy(10);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.resizeAndMoveBy(11);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.resizeAndMoveBy(20);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.setLength(0);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.setLength(-1);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.moveTo(-1);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.setEnd(5);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.setEnd(3);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.setEnd(-5);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.setStart(18);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.moveEndTo(9);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.setLengthAndMove(16);
            Assert.fail();
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)5L, (long)r.start());
            Assert.assertEquals((long)10L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
    }

    @Test
    public void testIllegalSplit() throws Exception {
        Range r = Range.createRelative((int)12, (int)18);
        try {
            r.split(-1);
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)12L, (long)r.start());
            Assert.assertEquals((long)18L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.split(0);
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)12L, (long)r.start());
            Assert.assertEquals((long)18L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.split(18);
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)12L, (long)r.start());
            Assert.assertEquals((long)18L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
        try {
            r.split(20);
        }
        catch (LineIndexOutOfBoundsException lineIndexOutOfBoundsException) {
            Assert.assertEquals((long)12L, (long)r.start());
            Assert.assertEquals((long)18L, (long)r.length());
            RangeTest.assertConsistency(r);
        }
    }

    private static void assertConsistency(Range r) {
        Assert.assertEquals((Object)r, (Object)r);
        Assert.assertTrue((boolean)r.equalRange((ILineRange)Range.copy((Range)r)));
        Assert.assertTrue((boolean)r.equalRange((ILineRange)Range.createRelative((int)r.start(), (int)r.length())));
        Assert.assertTrue((boolean)r.equalRange((ILineRange)Range.createAbsolute((int)r.start(), (int)r.end())));
        Assert.assertEquals((long)r.getStartLine(), (long)r.start());
        Assert.assertEquals((long)r.getNumberOfLines(), (long)r.length());
        Assert.assertEquals((long)(r.start() + r.length()), (long)r.end());
    }
}

