/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests.rulers;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.ui.internal.texteditor.rulers.DAG;
import org.junit.Assert;
import org.junit.Test;

public class DAGTest {
    private static final Object A = "A";
    private static final Object B = "B";
    private static final Object C = "C";
    private static final Object D = "D";
    private static final Set<Object> AS = Collections.singleton(A);
    private static final Set<Object> BS = Collections.singleton(B);
    private static final Set<Object> CS = Collections.singleton(C);
    private static final Set<Object> AD = new LinkedHashSet<Object>(Arrays.asList(A, D));
    private static final Set<Object> CD = new LinkedHashSet<Object>(Arrays.asList(C, D));
    private static final Set<Object> ACD = new LinkedHashSet<Object>(Arrays.asList(A, C, D));
    private static final Set<Object> BD = new LinkedHashSet<Object>(Arrays.asList(B, D));
    private DAG<Object> fDag = new DAG();

    @Test
    public void testEmpty() throws Exception {
        Assert.assertTrue((boolean)this.fDag.getChildren(new Object()).isEmpty());
        Assert.assertTrue((boolean)this.fDag.getSources().isEmpty());
        Assert.assertTrue((boolean)this.fDag.getSinks().isEmpty());
    }

    @Test
    public void testIllegal() throws Exception {
        Assert.assertFalse((boolean)this.fDag.addEdge(A, A));
        try {
            this.fDag.addEdge(A, null);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {}
        try {
            this.fDag.addEdge(null, A);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {}
        try {
            this.fDag.addEdge(null, null);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {}
        try {
            this.fDag.addVertex(null);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {}
    }

    @Test
    public void testDag() throws Exception {
        Assert.assertTrue((boolean)this.fDag.addEdge(A, B));
        Assert.assertEquals(AS, (Object)this.fDag.getSources());
        Assert.assertEquals(BS, (Object)this.fDag.getSinks());
        Assert.assertFalse((boolean)this.fDag.addEdge(B, A));
        Assert.assertEquals(AS, (Object)this.fDag.getSources());
        Assert.assertEquals(BS, (Object)this.fDag.getSinks());
        Assert.assertEquals(BS, (Object)this.fDag.getChildren(A));
        Assert.assertTrue((boolean)this.fDag.getChildren(B).isEmpty());
        Assert.assertTrue((boolean)this.fDag.getChildren(C).isEmpty());
        Assert.assertTrue((boolean)this.fDag.getChildren(D).isEmpty());
        Assert.assertTrue((boolean)this.fDag.addEdge(B, C));
        Assert.assertEquals(AS, (Object)this.fDag.getSources());
        Assert.assertEquals(CS, (Object)this.fDag.getSinks());
        Assert.assertEquals(BS, (Object)this.fDag.getChildren(A));
        Assert.assertEquals(CS, (Object)this.fDag.getChildren(B));
        Assert.assertTrue((boolean)this.fDag.getChildren(C).isEmpty());
        Assert.assertTrue((boolean)this.fDag.getChildren(D).isEmpty());
        this.fDag.addVertex(C);
        Assert.assertEquals(AS, (Object)this.fDag.getSources());
        Assert.assertEquals(CS, (Object)this.fDag.getSinks());
        Assert.assertEquals(BS, (Object)this.fDag.getChildren(A));
        Assert.assertEquals(CS, (Object)this.fDag.getChildren(B));
        Assert.assertTrue((boolean)this.fDag.getChildren(C).isEmpty());
        Assert.assertTrue((boolean)this.fDag.getChildren(D).isEmpty());
        this.fDag.addVertex(D);
        Assert.assertEquals(AD, (Object)this.fDag.getSources());
        Assert.assertEquals(CD, (Object)this.fDag.getSinks());
        Assert.assertEquals(BS, (Object)this.fDag.getChildren(A));
        Assert.assertEquals(CS, (Object)this.fDag.getChildren(B));
        Assert.assertTrue((boolean)this.fDag.getChildren(C).isEmpty());
        Assert.assertTrue((boolean)this.fDag.getChildren(D).isEmpty());
        this.fDag.removeVertex(A);
        Assert.assertEquals(BD, (Object)this.fDag.getSources());
        Assert.assertEquals(CD, (Object)this.fDag.getSinks());
        Assert.assertTrue((boolean)this.fDag.getChildren(A).isEmpty());
        Assert.assertEquals(CS, (Object)this.fDag.getChildren(B));
        Assert.assertTrue((boolean)this.fDag.getChildren(C).isEmpty());
        Assert.assertTrue((boolean)this.fDag.getChildren(D).isEmpty());
        Assert.assertTrue((boolean)this.fDag.addEdge(A, B));
        Assert.assertTrue((boolean)this.fDag.addEdge(D, B));
        Assert.assertEquals(AD, (Object)this.fDag.getSources());
        Assert.assertEquals(CS, (Object)this.fDag.getSinks());
        Assert.assertEquals(BS, (Object)this.fDag.getChildren(A));
        Assert.assertEquals(CS, (Object)this.fDag.getChildren(B));
        Assert.assertTrue((boolean)this.fDag.getChildren(C).isEmpty());
        Assert.assertEquals(BS, (Object)this.fDag.getChildren(D));
        this.fDag.removeVertex(B);
        Assert.assertEquals(ACD, (Object)this.fDag.getSources());
        Assert.assertEquals(ACD, (Object)this.fDag.getSinks());
        Assert.assertTrue((boolean)this.fDag.getChildren(A).isEmpty());
        Assert.assertTrue((boolean)this.fDag.getChildren(B).isEmpty());
        Assert.assertTrue((boolean)this.fDag.getChildren(C).isEmpty());
        Assert.assertTrue((boolean)this.fDag.getChildren(D).isEmpty());
    }
}

