/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Parse;
import fit.exception.FitParseException;
import junit.framework.TestCase;

public class ParseTest
extends TestCase {
    public void testParsing() throws Exception {
        Parse p = new Parse("leader<Table foo=2>body</table>trailer", new String[]{"table"});
        ParseTest.assertEquals((String)"leader", (String)p.leader);
        ParseTest.assertEquals((String)"<Table foo=2>", (String)p.tag);
        ParseTest.assertEquals((String)"body", (String)p.body);
        ParseTest.assertEquals((String)"trailer", (String)p.trailer);
    }

    public void testRecursing() throws Exception {
        Parse p = new Parse("leader<table><TR><Td>body</tD></TR></table>trailer");
        ParseTest.assertEquals(null, (String)p.body);
        ParseTest.assertEquals(null, (String)p.parts.body);
        ParseTest.assertEquals((String)"body", (String)p.parts.parts.body);
    }

    public void testIterating() throws Exception {
        Parse p = new Parse("leader<table><tr><td>one</td><td>two</td><td>three</td></tr></table>trailer");
        ParseTest.assertEquals((String)"one", (String)p.parts.parts.body);
        ParseTest.assertEquals((String)"two", (String)p.parts.parts.more.body);
        ParseTest.assertEquals((String)"three", (String)p.parts.parts.more.more.body);
    }

    public void testIndexing() throws Exception {
        Parse p = new Parse("leader<table><tr><td>one</td><td>two</td><td>three</td></tr><tr><td>four</td></tr></table>trailer");
        ParseTest.assertEquals((String)"one", (String)p.at((int)0, (int)0, (int)0).body);
        ParseTest.assertEquals((String)"two", (String)p.at((int)0, (int)0, (int)1).body);
        ParseTest.assertEquals((String)"three", (String)p.at((int)0, (int)0, (int)2).body);
        ParseTest.assertEquals((String)"three", (String)p.at((int)0, (int)0, (int)3).body);
        ParseTest.assertEquals((String)"three", (String)p.at((int)0, (int)0, (int)4).body);
        ParseTest.assertEquals((String)"four", (String)p.at((int)0, (int)1, (int)0).body);
        ParseTest.assertEquals((String)"four", (String)p.at((int)0, (int)1, (int)1).body);
        ParseTest.assertEquals((String)"four", (String)p.at((int)0, (int)2, (int)0).body);
        ParseTest.assertEquals((int)1, (int)p.size());
        ParseTest.assertEquals((int)2, (int)p.parts.size());
        ParseTest.assertEquals((int)3, (int)p.parts.parts.size());
        ParseTest.assertEquals((String)"one", (String)p.leaf().body);
        ParseTest.assertEquals((String)"four", (String)p.parts.last().leaf().body);
    }

    public void testText() throws Exception {
        String[] tags = new String[]{"td"};
        Parse p = new Parse("<td>a&lt;b</td>", tags);
        ParseTest.assertEquals((String)"a&lt;b", (String)p.body);
        ParseTest.assertEquals((String)"a<b", (String)p.text());
        p = new Parse("<td>\ta&gt;b&nbsp;&amp;&nbsp;b>c &&&nbsp;</td>", tags);
        ParseTest.assertEquals((String)"a>b & b>c &&", (String)p.text());
        p = new Parse("<td>\ta&gt;b&nbsp;&amp;&nbsp;b>c &&nbsp;</td>", tags);
        ParseTest.assertEquals((String)"a>b & b>c &", (String)p.text());
        p = new Parse("<TD><P><FONT FACE=\"Arial\" SIZE=2>GroupTestFixture</FONT></TD>", tags);
        ParseTest.assertEquals((String)"GroupTestFixture", (String)p.text());
    }

    public void testUnescape() {
        ParseTest.assertEquals((String)"a<b", (String)Parse.unescape("a&lt;b"));
        ParseTest.assertEquals((String)"a>b & b>c &&", (String)Parse.unescape("a&gt;b&nbsp;&amp;&nbsp;b>c &&"));
        ParseTest.assertEquals((String)"&amp;&amp;", (String)Parse.unescape("&amp;amp;&amp;amp;"));
        ParseTest.assertEquals((String)"a>b & b>c &&", (String)Parse.unescape("a&gt;b&nbsp;&amp;&nbsp;b>c &&"));
    }

    public void testUnformat() {
        ParseTest.assertEquals((String)"ab", (String)Parse.unformat("<font size=+1>a</font>b"));
        ParseTest.assertEquals((String)"ab", (String)Parse.unformat("a<font size=+1>b</font>"));
        ParseTest.assertEquals((String)"a<b", (String)Parse.unformat("a<b"));
    }

    public void testFindNestedEnd() throws FitParseException {
        ParseTest.assertEquals((int)0, (int)Parse.findMatchingEndTag("</t>", 0, "t", 0));
        ParseTest.assertEquals((int)7, (int)Parse.findMatchingEndTag("<t></t></t>", 0, "t", 0));
        ParseTest.assertEquals((int)14, (int)Parse.findMatchingEndTag("<t></t><t></t></t>", 0, "t", 0));
    }

    public void testNestedTables() throws Exception {
        String nestedTable = "<table><tr><td>embedded</td></tr></table>";
        Parse p = new Parse("<table><tr><td>" + nestedTable + "</td></tr>" + "<tr><td>two</td></tr><tr><td>three</td></tr></table>trailer");
        Parse sub = p.at((int)0, (int)0, (int)0).parts;
        ParseTest.assertEquals((int)1, (int)p.size());
        ParseTest.assertEquals((int)3, (int)p.parts.size());
        ParseTest.assertEquals((int)1, (int)sub.at(0, 0, 0).size());
        ParseTest.assertEquals((String)"embedded", (String)sub.at((int)0, (int)0, (int)0).body);
        ParseTest.assertEquals((int)1, (int)sub.size());
        ParseTest.assertEquals((int)1, (int)sub.parts.size());
        ParseTest.assertEquals((int)1, (int)sub.parts.parts.size());
        ParseTest.assertEquals((String)"two", (String)p.at((int)0, (int)1, (int)0).body);
        ParseTest.assertEquals((String)"three", (String)p.at((int)0, (int)2, (int)0).body);
        ParseTest.assertEquals((int)1, (int)p.at(0, 1, 0).size());
        ParseTest.assertEquals((int)1, (int)p.at(0, 2, 0).size());
    }

    public void testNestedTables2() throws Exception {
        String nestedTable = "<table><tr><td>embedded</td></tr></table>";
        String nestedTable2 = "<table><tr><td>" + nestedTable + "</td></tr><tr><td>two</td></tr></table>";
        Parse p = new Parse("<table><tr><td>one</td></tr><tr><td>" + nestedTable2 + "</td></tr>" + "<tr><td>three</td></tr></table>trailer");
        ParseTest.assertEquals((int)1, (int)p.size());
        ParseTest.assertEquals((int)3, (int)p.parts.size());
        ParseTest.assertEquals((String)"one", (String)p.at((int)0, (int)0, (int)0).body);
        ParseTest.assertEquals((String)"three", (String)p.at((int)0, (int)2, (int)0).body);
        ParseTest.assertEquals((int)1, (int)p.at(0, 0, 0).size());
        ParseTest.assertEquals((int)1, (int)p.at(0, 2, 0).size());
        Parse sub = p.at((int)0, (int)1, (int)0).parts;
        ParseTest.assertEquals((int)2, (int)sub.parts.size());
        ParseTest.assertEquals((int)1, (int)sub.at(0, 0, 0).size());
        Parse subSub = sub.at((int)0, (int)0, (int)0).parts;
        ParseTest.assertEquals((String)"embedded", (String)subSub.at((int)0, (int)0, (int)0).body);
        ParseTest.assertEquals((int)1, (int)subSub.at(0, 0, 0).size());
        ParseTest.assertEquals((String)"two", (String)sub.at((int)0, (int)1, (int)0).body);
        ParseTest.assertEquals((int)1, (int)sub.at(0, 1, 0).size());
    }
}

