/*
 * Decompiled with CFR 0.152.
 */
package fit.eg.bowling;

import fit.eg.bowling.Bowling;
import fit.eg.bowling.BowlingScorer;

public class BowlingGame
implements Bowling {
    private static final int FIRST_BALL_IN_FRAME = 0;
    private static final int SECOND_BALL_IN_FRAME = 1;
    private static final int GAME_OVER = 2;
    private static final int BALL_AFTER_SPARE = 3;
    private static final int BALL_AFTER_TENTH_FRAME_SPARE = 4;
    private static final int BALL_AFTER_FIRST_STRIKE = 5;
    private static final int BALL_AFTER_SECOND_STRIKE = 6;
    private int currentFrame = 1;
    private int currentBall = 1;
    private int scoreableFrame = 0;
    private boolean gameOver = false;
    private int state = 0;
    private final BowlingScorer bowlingScorer = new BowlingScorer();

    private void changeState() {
        switch (this.state) {
            case 0: {
                this.firstBallInFrame();
                break;
            }
            case 1: {
                this.secondBallInFrame();
                break;
            }
            case 3: {
                this.ballAfterSpare();
                break;
            }
            case 4: {
                this.endGame();
                break;
            }
            case 5: {
                this.ballAfterFirstStrike();
                break;
            }
            case 6: {
                this.ballAfterSecondStrike();
            }
        }
    }

    private void firstBallInFrame() {
        if (this.bowlingScorer.lastRollWasStrike()) {
            this.state = 5;
            this.incrementFrame();
        } else {
            this.state = 1;
            this.currentBall = 2;
        }
    }

    private void secondBallInFrame() {
        if (this.bowlingScorer.lastRollWasSpare() && this.currentFrame == 10) {
            this.state = 4;
            this.currentBall = 3;
        } else if (this.bowlingScorer.lastRollWasSpare()) {
            this.state = 3;
            this.incrementFrame();
        } else if (this.currentFrame == 10) {
            this.endGame();
        } else {
            this.state = 0;
            this.scoreableFrame = this.currentFrame;
            this.incrementFrame();
        }
    }

    private void ballAfterSpare() {
        if (this.bowlingScorer.lastRollWasStrike()) {
            this.state = 5;
            ++this.scoreableFrame;
            this.incrementFrame();
        } else {
            this.state = 1;
            this.currentBall = 2;
            ++this.scoreableFrame;
        }
    }

    private void ballAfterFirstStrike() {
        if (this.bowlingScorer.lastRollWasStrike()) {
            this.state = 6;
            this.incrementFrame();
        } else {
            this.state = 1;
            this.currentBall = 2;
        }
    }

    private void ballAfterSecondStrike() {
        if (this.bowlingScorer.lastRollWasStrike() && this.currentFrame == 10 && this.currentBall == 3) {
            this.endGame();
        } else if (this.bowlingScorer.lastRollWasStrike()) {
            this.incrementFrame();
            ++this.scoreableFrame;
        } else {
            this.state = 1;
            this.currentBall = 2;
            ++this.scoreableFrame;
        }
    }

    private void endGame() {
        this.state = 2;
        this.currentBall = 0;
        this.scoreableFrame = 10;
        this.gameOver = true;
    }

    private void incrementFrame() {
        if (this.currentFrame < 10) {
            ++this.currentFrame;
            this.currentBall = 1;
        } else {
            ++this.currentBall;
        }
    }

    @Override
    public int currentFrame() {
        return this.currentFrame;
    }

    @Override
    public int currentBall() {
        return this.currentBall;
    }

    @Override
    public int scoreableFrame() {
        return this.scoreableFrame;
    }

    @Override
    public boolean validGame() {
        return true;
    }

    @Override
    public boolean gameOver() {
        return this.currentFrame == 10 && this.currentBall == 0;
    }

    @Override
    public boolean isGameOver() {
        return this.gameOver;
    }

    @Override
    public void roll(int pins) {
        this.bowlingScorer.roll(pins);
        this.changeState();
    }

    @Override
    public int score(int frame) {
        return this.bowlingScorer.score(frame);
    }
}

