/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Row;
import java.util.List;

public class ActionSignature {
    public final String name;
    public final int arity;

    public ActionSignature(String name, int arity, RuntimeContextInternal runtimeContext) {
        this.name = runtimeContext.extendedCamel(name);
        this.arity = arity;
    }

    public String toString() {
        return this.name + "/" + this.arity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ActionSignature)) {
            return false;
        }
        ActionSignature other = (ActionSignature)obj;
        return this.arity == other.arity && this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode() + this.arity * 17;
    }

    public static ActionSignature create(Row row, int from, int upTo, boolean doStyle, RuntimeContextInternal runtime) {
        if (!doStyle) {
            return new ActionSignature(row.text(from, runtime), upTo - from - 1, runtime);
        }
        StringBuilder name = new StringBuilder(row.text(from, runtime));
        for (int i = from + 2; i < upTo; i += 2) {
            name.append(" ").append(row.text(i, runtime));
        }
        return new ActionSignature(name.toString(), (upTo - from) / 2, runtime);
    }

    public static ActionSignature doStyle(RuntimeContextInternal runtime, List<String> cells) {
        return ActionSignature.doStyle(runtime, cells.toArray(new String[0]));
    }

    public static ActionSignature doStyle(RuntimeContextInternal runtime, String ... cells) {
        String name = cells[0];
        for (int i = 2; i < cells.length; i += 2) {
            name = name + " " + cells[i];
        }
        return new ActionSignature(name, cells.length / 2, runtime);
    }

    public static ActionSignature seqStyle(RuntimeContextInternal runtime, List<String> cells) {
        return ActionSignature.seqStyle(runtime, cells.toArray(new String[0]));
    }

    public static ActionSignature seqStyle(RuntimeContextInternal runtime, String ... cells) {
        return new ActionSignature(cells[0], cells.length - 1, runtime);
    }
}

