/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.table.Row;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.caller.SpecialCaller;
import fitlibrary.traverse.workflow.caller.TwoStageSpecial;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestSpecialCaller {
    Mockery context = new Mockery();
    Evaluator evaluator = (Evaluator)this.context.mock(Evaluator.class);
    LookupMethodTarget lookupMethodTarget = (LookupMethodTarget)this.context.mock(LookupMethodTarget.class);
    Row row = (Row)this.context.mock(Row.class);
    TwoStageSpecial lazySpecial = (TwoStageSpecial)this.context.mock(TwoStageSpecial.class);
    ICalledMethodTarget specialMethod = (ICalledMethodTarget)this.context.mock(ICalledMethodTarget.class);
    TestResults testResults = TestResultsFactory.testResults();

    @Test
    public void invalidAsMethodUnknown() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestSpecialCaller.this.row)).text(0, TestSpecialCaller.this.evaluator);
                this.will(1.returnValue((Object)"a"));
                ((LookupMethodTarget)this.one(TestSpecialCaller.this.lookupMethodTarget)).findSpecialMethod(TestSpecialCaller.this.evaluator, "a");
                this.will(1.returnValue(null));
            }
        });
        SpecialCaller specialCaller = new SpecialCaller(this.row, this.evaluator, this.lookupMethodTarget);
        MatcherAssert.assertThat((Object)specialCaller.isValid(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void invalidAsSpecialMethodThrowsException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestSpecialCaller.this.row)).text(0, TestSpecialCaller.this.evaluator);
                this.will(2.returnValue((Object)"a"));
                ((LookupMethodTarget)this.one(TestSpecialCaller.this.lookupMethodTarget)).findSpecialMethod(TestSpecialCaller.this.evaluator, "a");
                this.will(2.returnValue((Object)TestSpecialCaller.this.specialMethod));
                ((ICalledMethodTarget)this.allowing(TestSpecialCaller.this.specialMethod)).getReturnType();
                this.will(2.returnValue(TwoStageSpecial.class));
                ((ICalledMethodTarget)this.one(TestSpecialCaller.this.specialMethod)).invoke((Object[])this.with(2.any(Object[].class)));
                this.will(2.throwException((Throwable)new RuntimeException()));
            }
        });
        SpecialCaller specialCaller = new SpecialCaller(this.row, this.evaluator, this.lookupMethodTarget);
        MatcherAssert.assertThat((Object)specialCaller.isValid(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void validButNotLazy() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestSpecialCaller.this.row)).text(0, TestSpecialCaller.this.evaluator);
                this.will(3.returnValue((Object)"a"));
                ((LookupMethodTarget)this.one(TestSpecialCaller.this.lookupMethodTarget)).findSpecialMethod(TestSpecialCaller.this.evaluator, "a");
                this.will(3.returnValue((Object)TestSpecialCaller.this.specialMethod));
                ((ICalledMethodTarget)this.allowing(TestSpecialCaller.this.specialMethod)).getReturnType();
                this.will(3.returnValue(Void.class));
                ((ICalledMethodTarget)this.one(TestSpecialCaller.this.specialMethod)).invoke((Object[])this.with(3.any(Object[].class)));
                this.will(3.returnValue((Object)"result"));
            }
        });
        SpecialCaller specialCaller = new SpecialCaller(this.row, this.evaluator, this.lookupMethodTarget);
        MatcherAssert.assertThat((Object)specialCaller.isValid(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)specialCaller.run(this.row, this.testResults).getSubject(), (Matcher)CoreMatchers.is((Object)"result"));
    }

    @Test
    public void validButLazy() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestSpecialCaller.this.row)).text(0, TestSpecialCaller.this.evaluator);
                this.will(4.returnValue((Object)"a"));
                ((LookupMethodTarget)this.one(TestSpecialCaller.this.lookupMethodTarget)).findSpecialMethod(TestSpecialCaller.this.evaluator, "a");
                this.will(4.returnValue((Object)TestSpecialCaller.this.specialMethod));
                ((ICalledMethodTarget)this.allowing(TestSpecialCaller.this.specialMethod)).getReturnType();
                this.will(4.returnValue(TwoStageSpecial.class));
                ((ICalledMethodTarget)this.one(TestSpecialCaller.this.specialMethod)).invoke((Object[])this.with(4.any(Object[].class)));
                this.will(4.returnValue((Object)TestSpecialCaller.this.lazySpecial));
                ((TwoStageSpecial)this.one(TestSpecialCaller.this.lazySpecial)).run(TestSpecialCaller.this.testResults);
            }
        });
        SpecialCaller specialCaller = new SpecialCaller(this.row, this.evaluator, this.lookupMethodTarget);
        MatcherAssert.assertThat((Object)specialCaller.isValid(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)specialCaller.run(this.row, this.testResults).getSubject(), (Matcher)CoreMatchers.is((Object)null));
    }
}

