/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Tables;
import fitlibrary.utility.CollectionUtility;
import java.util.HashSet;
import java.util.List;

public class ParameterBinder {
    private final List<String> formalParameters;
    private final Tables tables;
    private final String pageName;
    private String name;

    public ParameterBinder(String name, List<String> formalParameters, Tables tables, String pageName) {
        this.name = name;
        this.formalParameters = formalParameters;
        this.tables = tables;
        this.pageName = pageName;
    }

    public Tables getCopyOfBody() {
        return (Tables)this.tables.deepCopy();
    }

    public String getPageName() {
        return this.pageName;
    }

    public void verifyHeaderAgainstFormalParameters(Row row, VariableResolver resolver) {
        if (row.size() != this.formalParameters.size()) {
            throw new FitLibraryException("Expected " + this.formalParameters.size() + " parameters but there were " + row.size());
        }
        HashSet<String> set = new HashSet<String>();
        for (int c = 0; c < row.size(); ++c) {
            String headerName = row.text(c, resolver);
            if (!this.formalParameters.contains(headerName)) {
                throw new FitLibraryException("Unknown parameter: '" + headerName + "'");
            }
            if (set.contains(headerName)) {
                throw new FitLibraryException("Duplicate parameter: '" + headerName + "'");
            }
            set.add(headerName);
        }
    }

    public void bindMulti(Row parameterRow, Row callRow, DynamicVariables dynamicVariables) {
        if (callRow.size() != this.formalParameters.size()) {
            throw new FitLibraryException("Expected " + this.formalParameters.size() + " parameters but there were " + callRow.size());
        }
        for (int c = 0; c < callRow.size(); ++c) {
            String parameter = parameterRow.text(c, dynamicVariables);
            if (((Cell)callRow.at(c)).hasEmbeddedTables(dynamicVariables)) {
                dynamicVariables.putParameter(parameter, ((Cell)callRow.at(c)).getEmbeddedTables());
                continue;
            }
            dynamicVariables.putParameter(parameter, callRow.text(c, dynamicVariables));
        }
    }

    public void bindUni(List<Object> actualArgs, DynamicVariables dynamicVariables) {
        if (actualArgs.size() != this.formalParameters.size()) {
            throw new FitLibraryException("Expected " + this.formalParameters.size() + " parameters but there were " + actualArgs.size());
        }
        for (int c = 0; c < this.formalParameters.size(); ++c) {
            dynamicVariables.putParameter(this.formalParameters.get(c), actualArgs.get(c));
        }
    }

    public String getParameterList() {
        return "(" + CollectionUtility.mkString(",", this.formalParameters) + ")";
    }

    public String getName() {
        return this.name + this.getParameterList();
    }
}

