/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.domainAdapter;

import fitlibrary.annotation.NullaryAction;
import fitlibrary.annotation.ShowSelectedActions;
import fitlibrary.annotation.SimpleAction;
import fitlibrary.traverse.DomainAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

@ShowSelectedActions
public class AbstractFileHandler
implements DomainAdapter {
    protected File file = new File(".");

    @SimpleAction(wiki="|''<i>append</i>''|contents|", tooltip="Append the contents to the end of the file.")
    public void append(String content) throws IOException {
        this.writeToFile(content, true);
    }

    @SimpleAction(wiki="|''<i>write</i>''|contents|", tooltip="Write the contents to the file.")
    public void write(String content) throws IOException {
        this.writeToFile(content, false);
    }

    @SimpleAction(wiki="|''<i>append unicode</i>''|contents|", tooltip="Append the contents as unicode to the end of the file.")
    public void appendUnicode(String content) throws IOException {
        this.writeUnicodeToFile(content, true);
    }

    @SimpleAction(wiki="|''<i>write unicode</i>''|contents|", tooltip="Write the contents as unicode to the file.")
    public void writeUnicode(String content) throws IOException {
        this.writeUnicodeToFile(content, false);
    }

    @NullaryAction(tooltip="Read the contents of the file, so we can use it or check (parts of) it.")
    public String read() throws IOException {
        return this.readFile();
    }

    public String readFile() throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        StringBuilder result = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            result.append(line).append("\n");
        }
        reader.close();
        return result.toString();
    }

    @SimpleAction(wiki="|''<i>make folders</i>''|folder name|", tooltip="Create this as a folder, along with any other folders that are needed to hold it.")
    public void makeFolders(String folderPath) throws SecurityException {
        new File(folderPath).mkdirs();
    }

    @NullaryAction(tooltip="Delete the file, returning true if it succeeded.")
    public boolean delete() {
        return this.file.delete();
    }

    public String toString() {
        return "FileHandler[" + this.file.getName() + "]";
    }

    private void writeToFile(String content, boolean append) throws IOException {
        FileWriter fileWriter = new FileWriter(this.file, append);
        fileWriter.write(content.replace("\\n", "\n"));
        fileWriter.close();
    }

    private void writeUnicodeToFile(String content, boolean append) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, append), "UTF8");
        out.write(content.replace("\\n", "\n"));
        out.close();
    }

    @Override
    public Object getSystemUnderTest() {
        return this.file;
    }
}

