/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.eg.chat;

import fitlibrary.eg.chat.Room;
import fitlibrary.eg.chat.User;
import fitlibrary.exception.FitLibraryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Chat {
    private List<User> users = new ArrayList<User>();
    private List<Room> rooms = new ArrayList<Room>();
    private Map<String, Room> roomsMap = new HashMap<String, Room>();
    private Map<String, User> usersMap = new HashMap<String, User>();

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        for (User user : users) {
            this.addUser(user);
        }
    }

    public List<Room> getRooms() {
        return this.rooms;
    }

    public void setRooms(List<Room> rooms) {
        for (Room room : rooms) {
            this.addRoom(room);
        }
    }

    public User getUser(String userName) {
        return this.usersMap.get(userName);
    }

    public Room getRoom(String roomName) {
        return this.roomsMap.get(roomName);
    }

    public boolean connectUser(String userName) {
        this.addUser(new User(userName));
        return true;
    }

    public void disconnectUser(String userName) {
        User user = this.getUser(userName);
        for (Room room : this.roomsMap.values()) {
            room.removeUser(user);
        }
        this.users.remove(user);
        this.usersMap.remove(userName);
    }

    public boolean userCreatesRoom(User user, String roomName) {
        this.addRoom(new Room(roomName, user));
        return true;
    }

    public boolean userEntersRoom(User user, Room room) {
        room.addUser(user);
        return true;
    }

    public boolean userRemovesRoom(User user, Room room) {
        if (room.isEmpty()) {
            this.rooms.remove(room);
            this.roomsMap.remove(room.getName());
        }
        throw new RuntimeException("Unable to remove room " + room.getName() + " because it's not empty");
    }

    private void addUser(User user) {
        if (this.usersMap.get(user.getName()) != null) {
            throw new FitLibraryException("User already exists");
        }
        this.users.add(user);
        this.usersMap.put(user.getName(), user);
    }

    private void addRoom(Room room) {
        if (this.roomsMap.get(room.getName()) != null) {
            throw new FitLibraryException("Room already exists");
        }
        this.rooms.add(room);
        this.roomsMap.put(room.getName(), room);
    }
}

