/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.traverse.workflow.StopWatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestGlobalMethodScope {
    final Mockery context = new Mockery();
    final RuntimeContextInternal runtimeContext = (RuntimeContextInternal)this.context.mock(RuntimeContextInternal.class);
    final DynamicVariables dynamicVariables = (DynamicVariables)this.context.mock(DynamicVariables.class);
    final GlobalActionScope globalScope = new GlobalActionScope();

    @Before
    public void regularAllowing() {
        this.globalScope.setRuntimeContext(this.runtimeContext);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.allowing(TestGlobalMethodScope.this.runtimeContext)).getDynamicVariables();
                this.will(1.returnValue((Object)TestGlobalMethodScope.this.dynamicVariables));
            }
        });
    }

    @Test
    public void getBecomesTimeout() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(TestGlobalMethodScope.this.runtimeContext)).getTimeout("becomes", 1000);
                this.will(2.returnValue((Object)1000));
            }
        });
        MatcherAssert.assertThat((Object)this.globalScope.becomesTimeout(), (Matcher)CoreMatchers.is((Object)1000));
    }

    @Test
    public void setBecomesTimeout() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(TestGlobalMethodScope.this.runtimeContext)).putTimeout("becomes", 5000);
            }
        });
        this.globalScope.becomesTimeout(5000);
    }

    @Test
    public void getTimeout() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(TestGlobalMethodScope.this.runtimeContext)).getTimeout("exists", 1000);
                this.will(4.returnValue((Object)1000));
            }
        });
        MatcherAssert.assertThat((Object)this.globalScope.getTimeout("exists"), (Matcher)CoreMatchers.is((Object)1000));
    }

    @Test
    public void putTimeout() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(TestGlobalMethodScope.this.runtimeContext)).putTimeout("exists", 5000);
            }
        });
        this.globalScope.putTimeout("exists", 5000);
    }

    @Test
    public void dynamicVariableDoesNotExist() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.oneOf(TestGlobalMethodScope.this.dynamicVariables)).get("unknown---???");
                this.will(6.returnValue(null));
            }
        });
        MatcherAssert.assertThat((Object)this.globalScope.getDynamicVariable("unknown---???"), (Matcher)CoreMatchers.is((Object)null));
    }

    @Test
    public void dynamicVariableExists() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.oneOf(TestGlobalMethodScope.this.dynamicVariables)).get("exists");
                this.will(7.returnValue((Object)"a"));
            }
        });
        MatcherAssert.assertThat((Object)this.globalScope.getDynamicVariable("exists"), (Matcher)CoreMatchers.is((Object)"a"));
    }

    @Test
    public void setDynamicVariable() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.oneOf(TestGlobalMethodScope.this.dynamicVariables)).put("exists", "a");
            }
        });
        this.globalScope.setDynamicVariable("exists", "a");
    }

    @Test
    public void clearDynamicVariable() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.oneOf(TestGlobalMethodScope.this.dynamicVariables)).clearAll();
            }
        });
        this.globalScope.clearDynamicVariables();
    }

    @Test(expected=FitLibraryException.class)
    public void theStopWatchNotStarted() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.oneOf(TestGlobalMethodScope.this.dynamicVariables)).get("$$STOP WATCH$$");
                this.will(10.returnValue(null));
            }
        });
        this.globalScope.stopWatch();
    }

    @Test
    public void startAndstopStopWatch() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.oneOf(TestGlobalMethodScope.this.dynamicVariables)).put((String)this.with("$$STOP WATCH$$"), this.with(11.aNonNull(StopWatch.class)));
                ((DynamicVariables)this.oneOf(TestGlobalMethodScope.this.dynamicVariables)).get("$$STOP WATCH$$");
                this.will(11.returnValue((Object)new StopWatch()));
            }
        });
        this.globalScope.startStopWatch();
        MatcherAssert.assertThat((Object)this.globalScope.stopWatch(), (Matcher)CoreMatchers.not((Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(5L))));
    }
}

