/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.flow.HasTypedSubjectsMatcher;
import fitlibrary.flow.IScopeState;
import fitlibrary.flow.ScopeStack;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.suite.SuiteFixture;
import fitlibrary.traverse.RuntimeContextual;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.traverse.workflow.FlowEvaluator;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.CollectionUtility;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestScopeStack {
    final Mockery context = new Mockery();
    final Object something = "something";
    final TypedObject someTypedObject = new GenericTypedObject(this.something);
    final Object other = 12;
    final TypedObject otherTypedObject = new GenericTypedObject(this.other);
    final DoTraverse doTraverse = new DoTraverse(this.something);
    final TypedObject doTypedObjectWithSomeSut = new GenericTypedObject(this.doTraverse);
    final TypedObject suiteTypedObject = new GenericTypedObject(new SuiteFixture());
    final List<TypedObject> emptyList = new ArrayList<TypedObject>();
    final RuntimeContextual global = (RuntimeContextual)this.context.mock(RuntimeContextual.class, "global");
    final TypedObject globalTypedObject = new GenericTypedObject(this.global);
    final FlowEvaluator flowEvaluator = (FlowEvaluator)this.context.mock(FlowEvaluatorThatIsRuntimeContextual.class);
    final RuntimeContextInternal runtime = (RuntimeContextInternal)this.context.mock(RuntimeContextInternal.class);
    final ScopeStack scopeStack = new ScopeStack(this.flowEvaluator, this.globalTypedObject);

    @Before
    public void generalExpectations() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FlowEvaluator)this.allowing(TestScopeStack.this.flowEvaluator)).getSystemUnderTest();
                this.will(1.returnValue(null));
                ((RuntimeContextual)this.allowing(TestScopeStack.this.global)).getSystemUnderTest();
                this.will(1.returnValue(null));
            }
        });
    }

    @Test
    public void initiallyObjectsInScope() {
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(new Class[0])));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfTable(), (Matcher)CoreMatchers.is(this.emptyList));
    }

    @Test
    public void onePushAffectsObjectsInScope() {
        this.scopeStack.push(this.someTypedObject);
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.something, this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(this.something.getClass())));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfTable(), (Matcher)CoreMatchers.is(this.emptyList));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfStorytest(), (Matcher)CoreMatchers.is(this.list(this.someTypedObject)));
    }

    @Test
    public void onePushWithSutAffectsObjectsInScope() {
        this.scopeStack.push(this.doTypedObjectWithSomeSut);
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.doTraverse, this.something, this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(this.something.getClass())));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfTable(), (Matcher)CoreMatchers.is(this.emptyList));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfStorytest(), (Matcher)CoreMatchers.is(this.list(this.doTypedObjectWithSomeSut)));
    }

    @Test
    public void sameOnePushedTwiceAffectsObjectsInScope() {
        this.scopeStack.push(this.someTypedObject);
        this.scopeStack.push(this.someTypedObject);
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.something, this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(this.something.getClass())));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfTable(), (Matcher)CoreMatchers.is(this.list(this.someTypedObject)));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfStorytest(), (Matcher)CoreMatchers.is(this.list(this.someTypedObject)));
    }

    @Test
    public void onePushAndPopAtEndOfStorytestAffectsObjectsInScope() {
        this.scopeStack.push(this.someTypedObject);
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfStorytest(), (Matcher)CoreMatchers.is(this.list(this.someTypedObject)));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfStorytest(), (Matcher)CoreMatchers.is(this.emptyList));
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(new Class[0])));
    }

    @Test
    public void twoPushesAffectsObjectsInScope() {
        this.scopeStack.push(this.someTypedObject);
        this.scopeStack.push(this.otherTypedObject);
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.other, this.something, this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(this.other.getClass(), this.something.getClass())));
    }

    @Test
    public void twoPushesAndTwoPopsAffectsObjectsInScope() {
        this.scopeStack.push(this.someTypedObject);
        this.scopeStack.push(this.otherTypedObject);
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfTable(), (Matcher)CoreMatchers.is(this.list(this.otherTypedObject)));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfStorytest(), (Matcher)CoreMatchers.is(this.list(this.someTypedObject)));
    }

    @Test
    public void pushSuiteEvaluatorAffectsObjectsInScope() {
        this.scopeStack.push(this.suiteTypedObject);
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.suiteTypedObject.getSubject(), this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(new Class[0])));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfTable(), (Matcher)CoreMatchers.is(this.emptyList));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfStorytest(), (Matcher)CoreMatchers.is(this.emptyList));
    }

    @Test
    public void oneExtraGlobalAffectsObjectsInScope() {
        final RuntimeContextual runtimeContextual = (RuntimeContextual)this.context.mock(RuntimeContextual.class, "global2");
        GenericTypedObject genericTypedObject = new GenericTypedObject(runtimeContextual);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextual)this.allowing(runtimeContextual)).getSystemUnderTest();
                this.will(2.returnValue(null));
            }
        });
        this.scopeStack.addGlobal(genericTypedObject);
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.global, runtimeContextual, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(runtimeContextual.getClass())));
        MatcherAssert.assertThat(this.scopeStack.poppedAtEndOfTable(), (Matcher)CoreMatchers.is(this.emptyList));
    }

    @Test
    public void restoreStateAfterNoChange() {
        this.scopeStack.push(this.someTypedObject);
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.something, this.global, this.flowEvaluator));
        IScopeState iScopeState = this.scopeStack.currentState();
        MatcherAssert.assertThat((Object)iScopeState.restore().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.something, this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(this.something.getClass())));
    }

    @Test
    public void restoreStateAfterChange() {
        this.scopeStack.push(this.someTypedObject);
        IScopeState iScopeState = this.scopeStack.currentState();
        this.scopeStack.push(this.otherTypedObject);
        MatcherAssert.assertThat(iScopeState.restore(), (Matcher)CoreMatchers.is(this.list(this.otherTypedObject)));
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.something, this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(this.something.getClass())));
    }

    @Test(expected=FitLibraryException.class)
    public void selectUnknown() {
        this.scopeStack.select("unknown");
    }

    @Test
    public void addNamedObjectAndSelect() {
        this.scopeStack.addNamedObject("x", this.someTypedObject);
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.something, this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(this.something.getClass())));
        this.scopeStack.select("x");
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.something, this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(this.something.getClass())));
    }

    @Test
    public void addTwoNamedObjectAndSelectBetweenThem() {
        this.scopeStack.addNamedObject("x", this.someTypedObject);
        this.scopeStack.addNamedObject("y", this.otherTypedObject);
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.something, this.other, this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(this.something.getClass(), this.other.getClass())));
        this.scopeStack.select("y");
        MatcherAssert.assertThat(this.scopeStack.objectsForLookup(), TestScopeStack.hasSubjects(this.other, this.something, this.global, this.flowEvaluator));
        MatcherAssert.assertThat(this.scopeStack.possibleClasses(), (Matcher)CoreMatchers.is(this.classList(this.other.getClass(), this.something.getClass())));
    }

    @Test
    public void switchRuntime() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FlowEvaluator)this.oneOf(TestScopeStack.this.flowEvaluator)).setRuntimeContext(TestScopeStack.this.runtime);
                ((RuntimeContextual)this.oneOf(TestScopeStack.this.global)).setRuntimeContext(TestScopeStack.this.runtime);
            }
        });
        this.scopeStack.switchRuntime(this.runtime);
    }

    @Test
    public void switchRuntimeWithExtraGlobal() {
        final RuntimeContextual runtimeContextual = (RuntimeContextual)this.context.mock(RuntimeContextual.class, "global2");
        GenericTypedObject genericTypedObject = new GenericTypedObject(runtimeContextual);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextual)this.allowing(runtimeContextual)).getSystemUnderTest();
                this.will(4.returnValue(null));
                ((FlowEvaluator)this.oneOf(TestScopeStack.this.flowEvaluator)).setRuntimeContext(TestScopeStack.this.runtime);
                ((RuntimeContextual)this.oneOf(TestScopeStack.this.global)).setRuntimeContext(TestScopeStack.this.runtime);
                ((RuntimeContextual)this.oneOf(runtimeContextual)).setRuntimeContext(TestScopeStack.this.runtime);
            }
        });
        this.scopeStack.addGlobal(genericTypedObject);
        this.scopeStack.switchRuntime(this.runtime);
    }

    @Test
    public void initiallyNotAbandoned() {
        MatcherAssert.assertThat((Object)this.scopeStack.isAbandon(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void setNotAbandoned() {
        this.scopeStack.setAbandon(true);
        MatcherAssert.assertThat((Object)this.scopeStack.isAbandon(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void initiallyNotStopOnError() {
        MatcherAssert.assertThat((Object)this.scopeStack.isStopOnError(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void setNotStopOnError() {
        this.scopeStack.setStopOnError(true);
        MatcherAssert.assertThat((Object)this.scopeStack.isStopOnError(), (Matcher)CoreMatchers.is((Object)true));
    }

    static Matcher<List<TypedObject>> hasSubjects(Object ... objectArray) {
        return new HasTypedSubjectsMatcher(objectArray);
    }

    private <T> List<T> list(T ... TArray) {
        return CollectionUtility.list(TArray);
    }

    private List<Class<?>> classList(Class<?> ... classArray) {
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz : classArray) {
            arrayList.add(clazz);
        }
        return arrayList;
    }

    public static interface FlowEvaluatorThatIsRuntimeContextual
    extends FlowEvaluator {
    }
}

