/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.collection;

import fitlibrary.parser.Parser;
import fitlibrary.parser.ParserTestCase;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.table.Cell;
import fitlibrary.table.TableFactory;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.workflow.DoEvaluator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCollectionParser {
    DoEvaluator evaluator = ParserTestCase.evaluatorWithRuntime();
    Collection list;
    public Collection aProp;

    @Before
    public void setUp() {
        this.list = new ArrayList();
        this.list.add("1");
        this.list.add("2");
        this.list.add("3");
        this.aProp = new ArrayList();
        this.aProp.add("4");
        this.aProp.add("5");
        this.aProp.add("6");
    }

    @Test
    public void parserAlone() throws Exception {
        Parser parser = Traverse.asTyped(this.list).parser(this.evaluator);
        String string = "1, 2, 3";
        Cell cell = TableFactory.cell(string);
        TestResults testResults = TestResultsFactory.testResults();
        Assert.assertThat((Object)parser.parseTyped(cell, testResults).getSubject(), (Matcher)CoreMatchers.is((Object)this.list));
        Assert.assertThat((Object)parser.matches(cell, this.list, testResults), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)parser.show(this.list), (Matcher)CoreMatchers.is((Object)string));
    }

    @Test
    public void parserWithMethod() throws Exception {
        Method method = this.getClass().getMethod("aMethod", new Class[0]);
        ResultParser resultParser = Traverse.asTypedObject(this).resultParser((Evaluator)this.evaluator, method);
        resultParser.setTarget(this);
        Assert.assertThat((Object)resultParser.getResult(), (Matcher)CoreMatchers.is((Object)this.aProp));
        Assert.assertThat((Object)resultParser.show(resultParser.getResult()), (Matcher)CoreMatchers.is((Object)"4, 5, 6"));
    }

    public Collection aMethod() {
        return this.aProp;
    }
}

