/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ref;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.utility.ClassUtility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EntityReference {
    private static final String[] forms = new String[]{"this", "the"};
    private static final String[] counts = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eigth", "nineth", "tenth"};
    private static Map<String, EntityReference> entityReferenceCache = new ConcurrentHashMap<String, EntityReference>();
    private Map<String, Integer> mapStringToInt = new HashMap<String, Integer>();
    private String entityClassName;

    public static EntityReference create(String name) {
        EntityReference ref = entityReferenceCache.get(name);
        if (ref == null) {
            ref = new EntityReference(name);
            entityReferenceCache.put(name, ref);
        }
        return ref;
    }

    protected EntityReference(String entityClassName) {
        this.entityClassName = entityClassName;
        this.createMap();
    }

    private void createMap() {
        for (int form = 0; form < forms.length; ++form) {
            String theForm = forms[form];
            this.put(theForm, new Integer(0));
            this.put(theForm + " " + this.entityClassName, new Integer(0));
            this.put(theForm + " last", new Integer(-1));
            this.put(theForm + " last " + this.entityClassName, -1);
            for (int count = 0; count < counts.length; ++count) {
                String theCountString = counts[count];
                Integer theCount = count;
                this.put(theCountString, theCount);
                this.put(theForm + " " + theCountString, theCount);
                this.put(theForm + " " + theCountString + " " + this.entityClassName, theCount);
                this.put(this.entityClassName + "#" + (count + 1), theCount);
            }
        }
    }

    private void put(String referenceString, Integer index) {
        this.mapStringToInt.put(referenceString.toLowerCase(), index);
    }

    public int getIndex(String text) {
        Integer result = this.mapStringToInt.get(text.toLowerCase());
        if (result == null) {
            throw new FitLibraryException("Reference not defined: '" + text + "'");
        }
        return result;
    }

    private String reference(int index, int count) {
        if (count == 1) {
            return "the " + this.entityClassName;
        }
        if (index >= counts.length) {
            return this.entityClassName + "#" + (index + 1);
        }
        return "the " + counts[index] + " " + this.entityClassName;
    }

    public static String reference(Object object, List<?> list) {
        int index = list.indexOf(object);
        String className = ClassUtility.simpleClassName(object.getClass());
        EntityReference referenceParser = new EntityReference(className);
        return referenceParser.reference(index, list.size());
    }
}

