/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec;

import fitlibrary.global.PlugBoard;
import fitlibrary.spec.SpecifyErrorReport;
import fitlibrary.table.Tables;
import fitlibrary.traverse.ShowAfter;
import fitlibrary.utility.HtmlUtils;

public class SpecifyErrorReported
implements SpecifyErrorReport {
    private final ShowAfter showAfter;

    public SpecifyErrorReported(ShowAfter showAfter) {
        this.showAfter = showAfter;
    }

    @Override
    public void actualResult(Tables actualTables) {
        actualTables.print("actual");
    }

    @Override
    public void sizeWrong(String path, int actualSize, int expectedSize) {
        this.showAfterTable("Size differs at " + path + ". Was " + actualSize + ". Expected " + expectedSize);
    }

    @Override
    public void cellTextWrong(String path, String actual, String expected) {
        this.showAfterTable("Cell text differs at " + path + this.wasExpected(actual, expected));
    }

    @Override
    public void leaderWrong(String path, String actual, String expected) {
        this.showAfterTable("Leader differs at " + path + this.wasExpected(actual, expected));
    }

    @Override
    public void tagLineWrong(String path, String actual, String expected) {
        this.showAfterTable("Tag line differs at " + path + this.wasExpected(actual, expected));
    }

    @Override
    public void trailerWrong(String path, String actual, String expected) {
        this.showAfterTable("Trailer differs at " + path + this.wasExpected(actual, expected));
    }

    private String wasExpected(String actualText, String expectedText) {
        return ". <table border=\"1\" cellspacing=\"0\">" + this.plainRow("Actual", "Expected") + this.row(actualText, expectedText) + this.optionalEscapedRow(actualText, expectedText) + this.row("" + actualText.length(), "" + expectedText.length()) + "</table>";
    }

    private String optionalEscapedRow(String actualText, String expectedText) {
        String actualEscaped = this.escape(actualText);
        String expectedEscaped = this.escape(expectedText);
        if (actualEscaped.equals(actualText) && expectedEscaped.equals(expectedText)) {
            return "";
        }
        return this.row(actualEscaped, expectedEscaped);
    }

    private String row(String actual, String expected) {
        return "<tr><td>" + actual + PlugBoard.stringDifferencing.differences(actual, expected) + "</td><td>" + expected + "</td></tr>\n";
    }

    private String plainRow(String actual, String expected) {
        return "<tr><td>" + actual + "</td><td>" + expected + "</td></tr>\n";
    }

    private String escape(String text) {
        return HtmlUtils.escape(text);
    }

    private void showAfterTable(String s) {
        this.showAfter.showAsAfterTable("Logs", s);
        System.out.println(s);
    }
}

