/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec;

import fitlibrary.dynamicVariable.GlobalDynamicVariables;
import fitlibrary.spec.SpecifyErrorReport;
import fitlibrary.spec.TablesCompare;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestTablesCompare {
    final Mockery context = new Mockery();
    final SpecifyErrorReport errorReport = (SpecifyErrorReport)this.context.mock(SpecifyErrorReport.class);
    final TablesCompare tablesCompare = new TablesCompare(this.errorReport, new GlobalDynamicVariables());

    @Test
    public void emptyStringEquals() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("", ""), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void stringEqualsIgnoringWhiteSpace() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("ab", "ab "), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void someTagsAndCharactersAreIgnored() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("\t\r<hr><hr/><br><br/>ab", "ab "), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void ignore() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("ab", "IGNORE"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void fitLabelContentsOfActualCanBeLonger() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("ab <span class=\"fit_label\">XYZ</span>cd", "ab <span class=\"fit_label\">X</span>cd"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void fitLabelContentsOfActualCanBeLongerButMustMatch() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("ab <span class=\"fit_label\">XYZ</span>", "ab <span class=\"fit_label\">Y</span>"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void prefixOfFitLabelMustMatch() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("ab <span class=\"fit_label\">XYZ</span>", "aB <span class=\"fit_label\">XYZ</span>"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void suffixOfFitLabelMustMatch() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("ab <span class=\"fit_label\">XYZ</span>YZ", "ab <span class=\"fit_label\">Y</span>YYZ"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void severalFitLabelsMatch() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("ab <span class=\"fit_label\">XYZ</span>cd<span class=\"fit_label\">XYZ</span>ef", "ab <span class=\"fit_label\">X</span>cd<span class=\"fit_label\">XY</span>ef"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void imagePathPartiallyIgnored() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("<span class=\"fit_grey\"><img src=\"gameImages/wall.jpg\"></span>", "<span class=\"fit_grey\"><img src=\"/files/gameImages/wall.jpg\"></span>"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void imagePathPartiallyIgnored2() {
        MatcherAssert.assertThat((Object)this.tablesCompare.equals("<img src=\"file:///fitnesse/FitNesseRoot/files/gameImages/wall.jpg\">", "<img src=\"/files/gameImages/wall.jpg\">"), (Matcher)CoreMatchers.is((Object)true));
    }
}

