/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse;

import fitlibrary.annotation.ShowSelectedActions;
import fitlibrary.closure.Closure;
import fitlibrary.differences.DifferenceInterface;
import fitlibrary.differences.FitNesseDifference;
import fitlibrary.differences.LocalFile;
import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.CycleException;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.flow.IScope;
import fitlibrary.global.PlugBoard;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.RowOnList;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.DomainAdapter;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.FitHandler;
import fitlibrary.traverse.ShowAfter;
import fitlibrary.typed.NonGenericTyped;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.Pair;
import fitlibraryGeneric.typed.GenericTyped;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@ShowSelectedActions
public abstract class Traverse
implements Evaluator,
ShowAfter {
    public static DifferenceInterface FITNESSE_DIFFERENCES = new FitNesseDifference();
    protected static FitHandler FIT_HANDLER = new FitHandler();
    public static final String FITNESSE_URL_KEY = "fitNesse.url";
    private TypedObject typedObjectUnderTest = new GenericTypedObject(null);
    protected RuntimeContextInternal runtimeContext;

    public Traverse() {
    }

    public Traverse(Object sut) {
        this.setSystemUnderTest(sut);
    }

    public Traverse(TypedObject typedObjectUnderTest) {
        this.typedObjectUnderTest = typedObjectUnderTest;
    }

    protected void registerParseDelegate(Class<?> type, Class<?> parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    protected void registerParseDelegate(Class<?> type, Object parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    protected void registerSuperParseDelegate(Class<?> type, Object superParseDelegate) {
        ParseDelegation.registerSuperParseDelegate(type, superParseDelegate);
    }

    public void setSystemUnderTest(Object sut) {
        if (sut instanceof TypedObject) {
            this.setTypedSystemUnderTest((TypedObject)sut);
        } else {
            this.setTypedSystemUnderTest(Traverse.asTypedObject(sut));
        }
    }

    private boolean cycleSUT(DomainAdapter domainAdapter, Object sut) {
        if (domainAdapter == sut) {
            return true;
        }
        if (sut instanceof DomainAdapter) {
            return this.cycleSUT(domainAdapter, ((DomainAdapter)sut).getSystemUnderTest());
        }
        return false;
    }

    @Override
    public Object getSystemUnderTest() {
        if (this.typedObjectUnderTest == null) {
            return null;
        }
        return this.typedObjectUnderTest.getSubject();
    }

    @Override
    public TypedObject getTypedSystemUnderTest() {
        return this.typedObjectUnderTest;
    }

    public void setTypedSystemUnderTest(TypedObject typedObject) {
        if (this.cycleSUT(this, typedObject.getSubject())) {
            throw new CycleException("systemUnderTest", this, typedObject.getSubject());
        }
        this.typedObjectUnderTest = typedObject;
    }

    public static void setDifferenceStrategy(DifferenceInterface difference) {
        FITNESSE_DIFFERENCES = difference;
    }

    public static DifferenceInterface getDifferenceStrategy() {
        return FITNESSE_DIFFERENCES;
    }

    public static LocalFile getLocalFile(String localFileName) {
        return FITNESSE_DIFFERENCES.getLocalFile(localFileName);
    }

    public static LocalFile getGlobalFile(String localFileName) {
        return FITNESSE_DIFFERENCES.getGlobalFile(localFileName);
    }

    public static String htmlLink(File file) {
        return FITNESSE_DIFFERENCES.getGlobalFile(file).htmlLink();
    }

    public static void setContext(File reportDiry) {
        FITNESSE_DIFFERENCES.setContext(reportDiry);
    }

    public String extendedCamel(String suppliedName) {
        return this.runtimeContext.extendedCamel(suppliedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpretWithinScope(Table table, RuntimeContextInternal runtime, TestResults testResults) {
        this.setRuntimeContext(runtime);
        IScope scope = runtime.getScope();
        scope.temporarilyAdd(this);
        try {
            this.interpretAfterFirstRow(table, testResults);
        }
        finally {
            scope.removeTemporary(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpretInnerTableWithInScope(Table table, RuntimeContextInternal runtime, TestResults testResults) {
        RowOnList row = new RowOnList();
        table.add(0, row);
        row.setIsHidden();
        try {
            this.interpretWithinScope(table, runtime, testResults);
        }
        finally {
            table.removeElementAt(0);
        }
    }

    public boolean doesInnerTablePass(Table table, RuntimeContextInternal runtime, TestResults testResults) {
        TestResults innerResults = TestResultsFactory.testResults();
        this.interpretInnerTableWithInScope(table, runtime, innerResults);
        testResults.add(innerResults);
        return innerResults.passed();
    }

    public boolean doesTablePass(Table table, RuntimeContextInternal runtime, TestResults testResults) {
        TestResults innerResults = TestResultsFactory.testResults();
        this.interpretWithinScope(table, runtime, innerResults);
        testResults.add(innerResults);
        return innerResults.passed();
    }

    public static FitHandler getFitHandler() {
        return FIT_HANDLER;
    }

    public static Typed asTyped(Class<?> type) {
        return new NonGenericTyped(type);
    }

    public static Typed asTyped(Object object) {
        return new NonGenericTyped(object.getClass());
    }

    public static Typed asTyped(Method method) {
        return new GenericTyped(method.getGenericReturnType(), true);
    }

    protected TypedObject asTypedObject() {
        return new GenericTypedObject(this);
    }

    public static TypedObject asTypedObject(Object sut) {
        if (sut instanceof TypedObject) {
            return (TypedObject)sut;
        }
        return new GenericTypedObject(sut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callStartCreatingObjectMethod(TypedObject object) throws IllegalAccessException, InvocationTargetException {
        IScope scope = this.getRuntimeContext().getScope();
        scope.temporarilyAdd(this);
        try {
            this.callCreatingMethod("startCreatingObject", object.getSubject());
        }
        finally {
            scope.removeTemporary(this);
        }
    }

    public void callStartCreatingObjectMethod(Object element) throws IllegalAccessException, InvocationTargetException {
        this.callCreatingMethod("startCreatingObject", element);
    }

    public void callEndCreatingObjectMethod(TypedObject object) throws IllegalAccessException, InvocationTargetException {
        if (object != null) {
            this.callCreatingMethod("endCreatingObject", object.getSubject());
        }
    }

    public void callEndCreatingObjectMethod(Object element) throws IllegalAccessException, InvocationTargetException {
        this.callCreatingMethod("endCreatingObject", element);
    }

    @Override
    public RuntimeContextInternal getRuntimeContext() {
        if (this.runtimeContext == null) {
            throw new NullPointerException("Runtime has not been injected into " + this + ". See .FitLibrary.AdvancedTutorial.RuntimeInjection.");
        }
        return this.runtimeContext;
    }

    @Override
    public IScope getScope() {
        return this.getRuntimeContext().getScope();
    }

    @Override
    public void setRuntimeContext(RuntimeContextInternal runtimeContext) {
        this.runtimeContext = runtimeContext;
        Traverse.setRuntimeContextDownSutChain(this, runtimeContext);
    }

    private static void setRuntimeContextDownSutChain(Object object, RuntimeContextInternal runtimeContext) {
        if (object instanceof DomainAdapter) {
            Traverse.setRuntimeContextDownSutChain(((DomainAdapter)object).getSystemUnderTest(), runtimeContext);
        }
    }

    public DynamicVariables getDynamicVariables() {
        return this.getRuntimeContext().getDynamicVariables();
    }

    public VariableResolver getResolver() {
        return this.getDynamicVariables();
    }

    @Override
    public Pair<String, Tables> resolve(String key) {
        return this.getResolver().resolve(key);
    }

    @Override
    public void setDynamicVariable(String key, Object value) {
        this.getDynamicVariables().put(key, value);
    }

    public Object getDynamicVariable(String key) {
        return this.getDynamicVariables().get(key);
    }

    private void callCreatingMethod(String creatingMethodName, Object element) throws IllegalAccessException, InvocationTargetException {
        Closure startCreatingMethod = PlugBoard.lookupTarget.findFixturingMethod(this, creatingMethodName, new Class[]{Object.class});
        if (startCreatingMethod != null) {
            startCreatingMethod.invoke(new Object[]{element});
        }
    }

    public void show(String s) {
        this.runtimeContext.show(s);
    }

    public void showAfterTable(String s) {
        this.showAsAfterTable("Logs", s);
    }

    @Override
    public void showAsAfterTable(String title, String s) {
        this.global().showAsAfterTable(title, s);
    }

    protected GlobalActionScope global() {
        return this.getRuntimeContext().getGlobal();
    }

    @Override
    public abstract Object interpretAfterFirstRow(Table var1, TestResults var2);
}

