/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.function;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.exception.table.ExtraCellsException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.global.PlugBoard;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.function.FunctionTraverse;
import java.util.ArrayList;
import java.util.List;

public class CombinationTraverse
extends FunctionTraverse {
    private List<Object> topValues = new ArrayList<Object>();
    private boolean methodOK = false;
    private ICalledMethodTarget methodTarget = null;
    private Parser firstParser;

    public CombinationTraverse() {
    }

    public CombinationTraverse(Object sut) {
        super(sut);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        this.bindFirstRowToTarget((Row)table.at(1), testResults);
        for (int i = 2; i < table.size(); ++i) {
            this.processRow((Row)table.at(i), testResults);
        }
        return null;
    }

    public void bindFirstRowToTarget(Row row, TestResults testResults) {
        Parser secondParser = null;
        try {
            this.methodTarget = PlugBoard.lookupTarget.findTheMethodMapped("combine", 2, this);
            Parser[] parameterParsers = this.methodTarget.getParameterParsers();
            this.firstParser = parameterParsers[0];
            secondParser = parameterParsers[1];
        }
        catch (Exception e) {
            row.error(testResults, e);
            return;
        }
        int rowLength = row.size();
        for (int i = 1; i < rowLength; ++i) {
            Cell cell = (Cell)row.at(i);
            try {
                this.topValues.add(secondParser.parseTyped(cell, testResults).getSubject());
                continue;
            }
            catch (Exception e) {
                cell.error(testResults, e);
                return;
            }
        }
        this.methodOK = true;
    }

    public void processRow(Row row, TestResults testResults) {
        if (!this.methodOK) {
            row.ignore(testResults);
            return;
        }
        try {
            Object arg1 = this.firstParser.parseTyped((Cell)row.at(0), testResults).getSubject();
            if (row.size() - 1 < this.topValues.size()) {
                throw new MissingCellsException("CombinationTraverse");
            }
            if (row.size() - 1 > this.topValues.size()) {
                throw new ExtraCellsException("CombinationTraverse");
            }
            for (int i = 1; i < row.size(); ++i) {
                Object result = this.methodTarget.invoke(new Object[]{arg1, this.topValues.get(i - 1)});
                this.methodTarget.checkResult((Cell)row.at(i), result, true, false, testResults);
            }
        }
        catch (Exception e) {
            row.error(testResults, e);
            return;
        }
    }
}

