/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow;

import fitlibrary.global.PlugBoard;
import fitlibrary.global.TemporaryPlugBoardForRuntime;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.traverse.workflow.caller.ValidCall;
import java.util.ArrayList;
import java.util.List;

public class PlainText {
    private final Row row;
    private final TestResults testResults;
    private final DoTraverse doTraverse;
    private String prefixAction = "";
    private String infixAction = "";
    private String infixPart = "";

    public PlainText(Row row, TestResults testResults, DoTraverse doTraverse) {
        this.row = row;
        this.testResults = testResults;
        this.doTraverse = doTraverse;
    }

    public void analyse() {
        String textCall = ((Cell)this.row.at(1)).fullText();
        ArrayList<ValidCall> results = new ArrayList<ValidCall>();
        this.findDefinedActionCallsFromPlainText(textCall, results);
        textCall = this.infixes(this.prefixes(textCall));
        this.findProperty("get", textCall, results);
        this.findProperty("is", textCall, results);
        this.findMethodsFromPlainText(textCall, results);
        this.row.removeElementAt(0);
        if (results.isEmpty()) {
            this.error("Unknown action");
            return;
        }
        if (results.size() > 1) {
            this.error("Ambiguous action (see details in logs after table)");
            this.doTraverse.showAfterTable("Possible action tables:<br/>");
            for (ValidCall call : results) {
                call.possibility(this.doTraverse.getRuntimeContext().getGlobal());
            }
            return;
        }
        this.row.clear();
        if (!"".equals(this.prefixAction)) {
            this.row.addCell("<b>" + this.prefixAction + "</b>");
        }
        for (String word : ((ValidCall)results.get(0)).getList()) {
            this.row.addCell(word);
        }
        if (!"".equals(this.infixPart)) {
            this.row.addCell("<b>" + this.infixAction + "</b>");
            this.row.addCell(this.infixPart);
        }
        this.doTraverse.interpretRowBeforeWrapping(this.row, this.testResults);
    }

    private void findDefinedActionCallsFromPlainText(String textCall, List<ValidCall> results) {
        TemporaryPlugBoardForRuntime.definedActionsRepository().findPlainTextCall(textCall, results);
    }

    private void findMethodsFromPlainText(String textCall, List<ValidCall> results) {
        PlugBoard.lookupTarget.findMethodsFromPlainText(textCall, results, this.doTraverse.getRuntimeContext());
    }

    private void error(String message) {
        ((Cell)this.row.at(0)).error(this.testResults, message);
    }

    private void findProperty(String prefix, String textCall, List<ValidCall> results) {
        int count = results.size();
        this.findMethodsFromPlainText(this.doTraverse.extendedCamel(prefix + " " + textCall), results);
        if (results.size() > count) {
            results.get(results.size() - 1).setCall(textCall);
        }
    }

    private String prefixes(String textCallOriginal) {
        String[] prefixes;
        String textCall = textCallOriginal;
        for (String prefix : prefixes = new String[]{"not", "reject", "show", "show after", "ensure"}) {
            String prefixString = prefix;
            if (!textCall.startsWith(prefixString)) continue;
            textCall = textCall.substring(prefixString.length());
            this.prefixAction = prefix;
        }
        return textCall;
    }

    private String infixes(String textCallOriginal) {
        String[] infixes;
        String textCall = textCallOriginal;
        for (String infix : infixes = new String[]{"is", "is not", "matches", "eventually matches", "does not match", "becomes", "contains", "eventually contains"}) {
            String infixString = "*" + infix + "*";
            int pos = textCall.indexOf(infixString);
            if (pos < 0) continue;
            this.infixPart = textCall.substring(pos + infixString.length());
            textCall = textCall.substring(0, pos);
            this.infixAction = infix;
        }
        return textCall;
    }
}

