/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.exception.AbandonException;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.global.PlugBoard;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.AbstractDoCaller;
import fitlibrary.typed.TypedObject;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.InvocationTargetException;

public class DoActionCaller
extends AbstractDoCaller {
    private ICalledMethodTarget target;
    private String methodName;

    public DoActionCaller(Row row, Evaluator evaluator, boolean sequencing, LookupMethodTarget lookupTarget) {
        this.methodName = row.methodNameForCamel(evaluator.getRuntimeContext());
        try {
            this.target = lookupTarget.findMethodByArity(row, 0, row.size(), !sequencing, evaluator);
        }
        catch (Exception e) {
            this.setProblem(e);
        }
    }

    @Override
    public boolean isValid() {
        return this.target != null;
    }

    @Override
    public TypedObject run(Row row, TestResults testResults) throws Exception {
        try {
            TypedObject typedResult = this.target.invokeTyped((Row)row.fromAt(1), testResults);
            Object result = null;
            if (typedResult != null) {
                result = typedResult.getSubject();
            }
            if (result instanceof Boolean) {
                this.target.color(row, (Boolean)result, testResults);
            }
            return typedResult;
        }
        catch (AbandonException e) {
            return new GenericTypedObject(null);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = PlugBoard.exceptionHandling.unwrapThrowable(e);
            if (throwable instanceof FitLibraryShowException) {
                ((Cell)row.at(0)).error(testResults);
            }
            throw e;
        }
    }

    @Override
    public String ambiguityErrorMessage() {
        return this.methodName + "() in " + this.target.getOwningClass().getName();
    }
}

