/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.special;

import fitlibrary.flow.GlobalActionScope;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.special.DoAction;
import fitlibrary.tableProxy.CellProxy;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestMatches {
    Mockery context = new Mockery();
    DoAction action = (DoAction)this.context.mock(DoAction.class);
    CellProxy cellProxy = (CellProxy)this.context.mock(CellProxy.class);
    RuntimeContextInternal runtime = (RuntimeContextInternal)this.context.mock(RuntimeContextInternal.class);
    GlobalActionScope globalActionScope = new GlobalActionScope();

    void actual(final Object object) throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.oneOf(TestMatches.this.action)).run();
                this.will(1.returnValue((Object)object));
            }
        });
    }

    @Before
    public void injectRuntime() {
        this.globalActionScope.setRuntimeContext(this.runtime);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.allowing(TestMatches.this.action)).cellAt(1);
                this.will(2.returnValue((Object)TestMatches.this.cellProxy));
                ((RuntimeContextInternal)this.allowing(TestMatches.this.runtime)).getTimeout("becomes", 1000);
                this.will(2.returnValue((Object)5));
            }
        });
    }

    @Test
    public void failsWithNullResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).fail("result is null");
            }
        });
        this.actual(null);
        this.globalActionScope.matches(this.action, "a");
    }

    @Test
    public void failsWithNullExpectation() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).fail("expected is null");
            }
        });
        this.globalActionScope.matches(this.action, null);
    }

    @Test
    public void passes() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).pass();
            }
        });
        this.actual("abc");
        this.globalActionScope.matches(this.action, "a.");
    }

    @Test
    public void fails() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).fail("abc");
            }
        });
        this.actual("abc");
        this.globalActionScope.matches(this.action, "Z.");
    }

    @Test
    public void doesNotContainFailsWithNullResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).fail("result is null");
            }
        });
        this.actual(null);
        this.globalActionScope.doesNotMatch(this.action, "a");
    }

    @Test
    public void doesNotContainFailsWithNullExpectation() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).fail("expected is null");
            }
        });
        this.globalActionScope.doesNotMatch(this.action, null);
    }

    @Test
    public void doesNotContainFails() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).fail("abc");
            }
        });
        this.actual("abc");
        this.globalActionScope.doesNotMatch(this.action, "a");
    }

    @Test
    public void doesNotContainPasses() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).pass();
            }
        });
        this.actual("abc");
        this.globalActionScope.doesNotMatch(this.action, "Z");
    }

    @Test
    public void eventuallyFailsWithNullResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.atLeast(1).of((Object)TestMatches.this.action)).run();
                this.will(11.returnValue(null));
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).fail("result is null");
            }
        });
        this.globalActionScope.eventuallyMatches(this.action, "a");
    }

    @Test
    public void eventuallyFailsWithNullExpectation() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.allowing(TestMatches.this.action)).cellAt(1);
                this.will(12.returnValue((Object)TestMatches.this.cellProxy));
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).fail("expected is null");
            }
        });
        this.globalActionScope.eventuallyMatches(this.action, null);
    }

    @Test
    public void eventuallyPasses() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).pass();
            }
        });
        this.actual("abc");
        this.globalActionScope.eventuallyMatches(this.action, "a");
    }

    @Test
    public void eventuallyPassesAfterFailing() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.oneOf(TestMatches.this.action)).run();
                this.will(14.returnValue((Object)"ZZ"));
                ((DoAction)this.oneOf(TestMatches.this.action)).run();
                this.will(14.returnValue((Object)"abc"));
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).pass();
            }
        });
        this.globalActionScope.eventuallyMatches(this.action, "a");
    }

    @Test
    public void eventuallyFails() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.atLeast(1).of((Object)TestMatches.this.action)).run();
                this.will(15.returnValue((Object)"abc"));
                ((CellProxy)this.oneOf(TestMatches.this.cellProxy)).fail("abc");
            }
        });
        this.globalActionScope.eventuallyMatches(this.action, "Z");
    }
}

