/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.special;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.traverse.workflow.caller.TwoStageSpecial;
import fitlibrary.traverse.workflow.special.SpecialActionContext;
import fitlibrary.traverse.workflow.special.SpecialActionTest;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestSet
extends SpecialActionTest {
    @Test
    public void setWithValueFromInnerMethod() throws Exception {
        this.context.checking((ExpectationBuilder)new SetExpectations(""){
            {
                ((SpecialActionContext)this.one(TestSet.this.actionContext)).findMethodFromRow(TestSet.this.initialRow, 2, 0);
                this.will(1.returnValue((Object)TestSet.this.target));
                ((ICalledMethodTarget)this.one(TestSet.this.target)).invokeForSpecial(TestSet.this.subRow, TestSet.this.testResults, true, TestSet.this.firstCell);
                this.will(1.returnValue((Object)"234"));
                ((SpecialActionContext)this.one(TestSet.this.actionContext)).setDynamicVariable("2nd", "234");
            }
        });
        TwoStageSpecial twoStageSpecial = this.special.set(this.initialRow);
        twoStageSpecial.run(this.testResults);
    }

    @Test
    public void innerMethodThrowsException() throws Exception {
        final RuntimeException runtimeException = new RuntimeException();
        this.context.checking((ExpectationBuilder)new SetExpectations(""){
            {
                super(string);
                ((SpecialActionContext)this.one(TestSet.this.actionContext)).findMethodFromRow(TestSet.this.initialRow, 2, 0);
                this.will(2.returnValue((Object)TestSet.this.target));
                ((ICalledMethodTarget)this.one(TestSet.this.target)).invokeForSpecial(TestSet.this.subRow, TestSet.this.testResults, true, TestSet.this.firstCell);
                this.will(2.throwException((Throwable)runtimeException));
                ((Row)this.one(TestSet.this.initialRow)).error(TestSet.this.testResults, runtimeException);
            }
        });
        TwoStageSpecial twoStageSpecial = this.special.set(this.initialRow);
        twoStageSpecial.run(this.testResults);
    }

    @Test
    public void innerMethodThrowsIgnoredException() throws Exception {
        final IgnoredException ignoredException = new IgnoredException();
        this.context.checking((ExpectationBuilder)new SetExpectations(""){
            {
                super(string);
                ((SpecialActionContext)this.one(TestSet.this.actionContext)).findMethodFromRow(TestSet.this.initialRow, 2, 0);
                this.will(3.returnValue((Object)TestSet.this.target));
                ((ICalledMethodTarget)this.one(TestSet.this.target)).invokeForSpecial(TestSet.this.subRow, TestSet.this.testResults, true, TestSet.this.firstCell);
                this.will(3.throwException((Throwable)ignoredException));
            }
        });
        TwoStageSpecial twoStageSpecial = this.special.set(this.initialRow);
        twoStageSpecial.run(this.testResults);
    }

    @Test
    public void setWithValueFromOfOgnl() throws Exception {
        this.context.checking((ExpectationBuilder)new SetExpectations("="){
            {
                ((Row)this.one(TestSet.this.initialRow)).text(3, TestSet.this.actionContext);
                this.will(4.returnValue((Object)"1+2"));
                ((Row)this.one(TestSet.this.initialRow)).at(3);
                this.will(4.returnValue((Object)TestSet.this.firstCell));
                ((Cell)this.one(TestSet.this.firstCell)).hasEmbeddedTables((VariableResolver)this.with(4.any(VariableResolver.class)));
                this.will(4.returnValue((Object)false));
                ((SpecialActionContext)this.one(TestSet.this.actionContext)).setDynamicVariable("2nd", 3);
            }
        });
        TwoStageSpecial twoStageSpecial = this.special.set(this.initialRow);
        twoStageSpecial.run(this.testResults);
    }

    @Test
    public void setNestedTables() throws Exception {
        this.context.checking((ExpectationBuilder)new SetExpectations("to"){
            {
                ((Row)this.allowing(TestSet.this.initialRow)).at(3);
                this.will(5.returnValue((Object)TestSet.this.firstCell));
                ((Cell)this.atLeast(2).of((Object)TestSet.this.firstCell)).hasEmbeddedTables((VariableResolver)this.with(5.any(VariableResolver.class)));
                this.will(5.returnValue((Object)true));
                ((Cell)this.one(TestSet.this.firstCell)).getEmbeddedTables();
                this.will(5.returnValue((Object)TestSet.this.tables));
                ((SpecialActionContext)this.one(TestSet.this.actionContext)).setDynamicVariable("2nd", TestSet.this.tables);
            }
        });
        TwoStageSpecial twoStageSpecial = this.special.set(this.initialRow);
        twoStageSpecial.run(this.testResults);
    }

    @Test(expected=RuntimeException.class)
    public void hasMissingMethod() throws Exception {
        this.context.checking((ExpectationBuilder)new SetExpectations(""){
            {
                ((SpecialActionContext)this.one(TestSet.this.actionContext)).findMethodFromRow(TestSet.this.initialRow, 2, 0);
                this.will(6.throwException((Throwable)new RuntimeException()));
            }
        });
        this.special.set(this.initialRow);
    }

    @Test(expected=MissingCellsException.class)
    public void rowIsTooSmall() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestSet.this.initialRow)).size();
                this.will(7.returnValue((Object)1));
            }
        });
        this.special.set(this.initialRow);
    }

    class SetExpectations
    extends Expectations {
        public SetExpectations(String string) throws Exception {
            ((Row)this.allowing(TestSet.this.initialRow)).size();
            this.will(SetExpectations.returnValue((Object)4));
            ((Row)this.allowing(TestSet.this.initialRow)).text(2, TestSet.this.actionContext);
            this.will(SetExpectations.returnValue((Object)string));
            ((Row)this.allowing(TestSet.this.initialRow)).at(0);
            this.will(SetExpectations.returnValue((Object)TestSet.this.firstCell));
            ((Row)this.allowing(TestSet.this.initialRow)).text(1, TestSet.this.actionContext);
            this.will(SetExpectations.returnValue((Object)"2nd"));
            ((Row)this.allowing(TestSet.this.initialRow)).fromAt(3);
            this.will(SetExpectations.returnValue((Object)TestSet.this.subRow));
        }
    }
}

