/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.typed;

import fitlibrary.closure.Closure;
import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.closure.LookupClosure;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.flow.IScope;
import fitlibrary.runtime.RuntimeContextContainer;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.special.DoAction;
import fitlibrary.special.PositionedTarget;
import fitlibrary.special.PositionedTargetFactory;
import fitlibrary.traverse.Evaluator;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestGenericTypedObjectFurther {
    final Mockery context = new Mockery();
    final Subject subject = (Subject)this.context.mock(Subject.class);
    final Evaluator evaluator = (Evaluator)this.context.mock(Evaluator.class);
    final LookupClosure lookupClosure = (LookupClosure)this.context.mock(LookupClosure.class);
    final Closure closure = (Closure)this.context.mock(Closure.class);
    final GenericTypedObject.MethodTargetFactory methodTargetFactory = (GenericTypedObject.MethodTargetFactory)this.context.mock(GenericTypedObject.MethodTargetFactory.class);
    final LookupMethodTarget lookupTarget = (LookupMethodTarget)this.context.mock(LookupMethodTarget.class);
    final ICalledMethodTarget calledMethodTarget = (ICalledMethodTarget)this.context.mock(ICalledMethodTarget.class);
    final PositionedTargetFactory positionedTargetFactory = (PositionedTargetFactory)this.context.mock(PositionedTargetFactory.class);
    final PositionedTarget positionedTarget = (PositionedTarget)this.context.mock(PositionedTarget.class);
    final IScope scope = (IScope)this.context.mock(IScope.class);
    final GenericTypedObject typedObject = new GenericTypedObject(this.subject, this.lookupClosure, this.methodTargetFactory);
    final RuntimeContextInternal runtime = new RuntimeContextContainer();

    @Test
    public void methodDoesNotExist() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((LookupClosure)this.oneOf(TestGenericTypedObjectFurther.this.lookupClosure)).findMethodClosure(TestGenericTypedObjectFurther.this.typedObject, "unknown", 0);
                this.will(1.returnValue(null));
            }
        });
        MatcherAssert.assertThat((Object)this.typedObject.new_findSpecificMethod("unknown", 0, this.evaluator).isNone(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void methodExistsOnEvaluator() throws Exception {
        this.verifyMethodOnEvaluator("m");
    }

    private void verifyMethodOnEvaluator(final String string) throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((GenericTypedObject.MethodTargetFactory)this.oneOf(TestGenericTypedObjectFurther.this.methodTargetFactory)).createCalledMethodTarget(TestGenericTypedObjectFurther.this.closure, TestGenericTypedObjectFurther.this.evaluator);
                ((LookupClosure)this.oneOf(TestGenericTypedObjectFurther.this.lookupClosure)).findMethodClosure(TestGenericTypedObjectFurther.this.typedObject, string, 0);
                this.will(2.returnValue((Object)TestGenericTypedObjectFurther.this.closure));
            }
        });
        MatcherAssert.assertThat((Object)this.typedObject.new_findSpecificMethod(string, 0, this.evaluator).isSome(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void doNotFindActionSpecialMethod() throws Exception {
        String[] stringArray = new String[]{"unknown"};
        List<PositionedTarget> list = this.typedObject.findActionSpecialMethods(stringArray, this.positionedTargetFactory, this.runtime);
        MatcherAssert.assertThat((Object)list.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void findNullaryActionSpecialMethod() throws Exception {
        PositionedTargetFactory positionedTargetFactory = new PositionedTargetFactory(){

            @Override
            public PositionedTarget create(Method method, int n, int n2) {
                MatcherAssert.assertThat((Object)method.getName(), (Matcher)CoreMatchers.is((Object)"nullarySpecial"));
                MatcherAssert.assertThat((Object)n, (Matcher)CoreMatchers.is((Object)1));
                MatcherAssert.assertThat((Object)n2, (Matcher)CoreMatchers.is((Object)2));
                return TestGenericTypedObjectFurther.this.positionedTarget;
            }
        };
        String[] stringArray = new String[]{"nullarySpecial", "m"};
        List<PositionedTarget> list = this.typedObject.findActionSpecialMethods(stringArray, positionedTargetFactory, this.runtime);
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void findNullaryReversedActionSpecialMethod() throws Exception {
        PositionedTargetFactory positionedTargetFactory = new PositionedTargetFactory(){

            @Override
            public PositionedTarget create(Method method, int n, int n2) {
                MatcherAssert.assertThat((Object)method.getName(), (Matcher)CoreMatchers.is((Object)"nullarySpecial"));
                MatcherAssert.assertThat((Object)n, (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)n2, (Matcher)CoreMatchers.is((Object)1));
                return TestGenericTypedObjectFurther.this.positionedTarget;
            }
        };
        String[] stringArray = new String[]{"m", "nullarySpecial"};
        List<PositionedTarget> list = this.typedObject.findActionSpecialMethods(stringArray, positionedTargetFactory, this.runtime);
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void findUnaryPostFixActionSpecialMethod() throws Exception {
        PositionedTargetFactory positionedTargetFactory = new PositionedTargetFactory(){

            @Override
            public PositionedTarget create(Method method, int n, int n2) {
                MatcherAssert.assertThat((Object)method.getName(), (Matcher)CoreMatchers.is((Object)"unaryPostSpecial"));
                MatcherAssert.assertThat((Object)n, (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)n2, (Matcher)CoreMatchers.is((Object)2));
                return TestGenericTypedObjectFurther.this.positionedTarget;
            }
        };
        String[] stringArray = new String[]{"m", "2", "unaryPostSpecial", "1"};
        List<PositionedTarget> list = this.typedObject.findActionSpecialMethods(stringArray, positionedTargetFactory, this.runtime);
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void findBinaryPreFixActionSpecialMethod() throws Exception {
        PositionedTargetFactory positionedTargetFactory = new PositionedTargetFactory(){

            @Override
            public PositionedTarget create(Method method, int n, int n2) {
                MatcherAssert.assertThat((Object)method.getName(), (Matcher)CoreMatchers.is((Object)"binaryPreSpecial"));
                MatcherAssert.assertThat((Object)n, (Matcher)CoreMatchers.is((Object)4));
                MatcherAssert.assertThat((Object)n2, (Matcher)CoreMatchers.is((Object)6));
                return TestGenericTypedObjectFurther.this.positionedTarget;
            }
        };
        String[] stringArray = new String[]{"binary", "1", "pre special", "2", "m", "a"};
        List<PositionedTarget> list = this.typedObject.findActionSpecialMethods(stringArray, positionedTargetFactory, this.runtime);
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void findBinaryPostFixActionSpecialMethod() throws Exception {
        PositionedTargetFactory positionedTargetFactory = new PositionedTargetFactory(){

            @Override
            public PositionedTarget create(Method method, int n, int n2) {
                MatcherAssert.assertThat((Object)method.getName(), (Matcher)CoreMatchers.is((Object)"binaryPostSpecial"));
                MatcherAssert.assertThat((Object)n, (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)n2, (Matcher)CoreMatchers.is((Object)2));
                return TestGenericTypedObjectFurther.this.positionedTarget;
            }
        };
        String[] stringArray = new String[]{"m", "a", "binary", "1", "post special", "2"};
        List<PositionedTarget> list = this.typedObject.findActionSpecialMethods(stringArray, positionedTargetFactory, this.runtime);
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    static interface Sut {
        public void m();
    }

    static interface Subject
    extends Evaluator {
        public void m();

        public void nullarySpecial(DoAction var1);

        public void unaryPostSpecial(DoAction var1, int var2);

        public void binaryPreSpecial(int var1, int var2, DoAction var3);

        public void binaryPostSpecial(DoAction var1, int var2, int var3);
    }
}

