/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.authentication.PasswordCipher;
import fitnesse.authentication.TransparentCipher;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import util.FileUtil;

public class PasswordFile {
    private File passwordFile;
    private Map<String, String> passwordMap = new HashMap<String, String>();
    private PasswordCipher cipher = new TransparentCipher();

    public PasswordFile(String filename) throws Exception {
        this.passwordFile = new File(filename);
        this.loadFile();
    }

    public PasswordFile(String filename, PasswordCipher cipher) throws Exception {
        this(filename);
        this.cipher = cipher;
    }

    public Map<String, String> getPasswordMap() {
        return this.passwordMap;
    }

    public String getName() {
        return this.passwordFile.getName();
    }

    public PasswordCipher getCipher() {
        return this.cipher;
    }

    public void savePassword(String user, String password) throws Exception {
        this.passwordMap.put(user, this.cipher.encrypt(password));
        this.savePasswords();
    }

    private void loadFile() throws Exception {
        LinkedList<String> lines = this.getPasswordFileLines();
        this.loadCipher(lines);
        this.loadPasswords(lines);
    }

    private void loadPasswords(LinkedList<String> lines) {
        for (String line : lines) {
            if ("".equals(line)) continue;
            String[] tokens = line.split(":");
            this.passwordMap.put(tokens[0], tokens[1]);
        }
    }

    private void loadCipher(LinkedList<String> lines) throws Exception {
        String firstLine;
        if (lines.size() > 0 && (firstLine = lines.getFirst().toString()).startsWith("!")) {
            String cipherClassName = firstLine.substring(1);
            this.instantiateCipher(cipherClassName);
            lines.removeFirst();
        }
    }

    public PasswordCipher instantiateCipher(String cipherClassName) throws Exception {
        Class<?> cipherClass = Class.forName(cipherClassName);
        Constructor<?> constructor = cipherClass.getConstructor(new Class[0]);
        this.cipher = (PasswordCipher)constructor.newInstance(new Object[0]);
        return this.cipher;
    }

    private void savePasswords() throws Exception {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("!" + this.cipher.getClass().getName());
        for (String user : this.passwordMap.keySet()) {
            String password = this.passwordMap.get(user);
            lines.add(user + ":" + password);
        }
        FileUtil.writeLinesToFile(this.passwordFile, lines);
    }

    private LinkedList<String> getPasswordFileLines() throws Exception {
        LinkedList<String> lines = new LinkedList<String>();
        if (this.passwordFile.exists()) {
            lines = FileUtil.getFileLines(this.passwordFile);
        }
        return lines;
    }
}

