/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.TimeMeasurement;

public class CommandRunner {
    protected Process process;
    protected String input = "";
    protected List<Throwable> exceptions = new ArrayList<Throwable>();
    protected OutputStream stdin;
    protected InputStream stdout;
    protected InputStream stderr;
    protected StringBuffer outputBuffer = new StringBuffer();
    protected StringBuffer errorBuffer = new StringBuffer();
    protected int exitCode = -1;
    private TimeMeasurement timeMeasurement = new TimeMeasurement();
    private String command = "";
    private Map<String, String> environmentVariables;

    public CommandRunner() {
    }

    public CommandRunner(String command, String input) {
        this(command, input, null);
    }

    public CommandRunner(String command, String input, Map<String, String> environmentVariables) {
        this.command = command;
        this.input = input;
        this.environmentVariables = environmentVariables;
    }

    public void asynchronousStart() throws Exception {
        Runtime rt = Runtime.getRuntime();
        this.timeMeasurement.start();
        String[] environmentVariables = this.determineEnvironment();
        this.process = rt.exec(this.command, environmentVariables);
        this.stdin = this.process.getOutputStream();
        this.stdout = this.process.getInputStream();
        this.stderr = this.process.getErrorStream();
        new Thread((Runnable)new OuputReadingRunnable(this.stdout, this.outputBuffer), "CommandRunner stdout").start();
        new Thread((Runnable)new OuputReadingRunnable(this.stderr, this.errorBuffer), "CommandRunner error").start();
        this.sendInput();
    }

    private String[] determineEnvironment() {
        if (this.environmentVariables == null) {
            return null;
        }
        HashMap<String, String> systemVariables = new HashMap<String, String>(System.getenv());
        systemVariables.putAll(this.environmentVariables);
        ArrayList<String> systemVariableAssignments = new ArrayList<String>();
        for (Map.Entry entry : systemVariables.entrySet()) {
            systemVariableAssignments.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        return systemVariableAssignments.toArray(new String[systemVariableAssignments.size()]);
    }

    public void run() throws Exception {
        this.asynchronousStart();
        this.join();
    }

    public void join() throws Exception {
        this.process.waitFor();
        this.timeMeasurement.stop();
        this.exitCode = this.process.exitValue();
    }

    public void kill() throws Exception {
        if (this.process != null) {
            this.process.destroy();
            this.join();
        }
    }

    protected void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public String getOutput() {
        return this.outputBuffer.toString();
    }

    public String getError() {
        return this.errorBuffer.toString();
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    public boolean hasExceptions() {
        return this.exceptions.size() > 0;
    }

    public boolean wroteToErrorStream() {
        return this.errorBuffer.length() > 0;
    }

    public boolean wroteToOutputStream() {
        return this.outputBuffer.length() > 0;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void exceptionOccurred(Exception e) {
        this.exceptions.add(e);
    }

    public long getExecutionTime() {
        return this.timeMeasurement.elapsed();
    }

    protected void sendInput() throws Exception {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CommandRunner.this.stdin.write(CommandRunner.this.input.getBytes("UTF-8"));
                    CommandRunner.this.stdin.flush();
                }
                catch (Exception e) {
                    CommandRunner.this.exceptionOccurred(e);
                }
                finally {
                    try {
                        CommandRunner.this.stdin.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        thread.start();
        thread.join();
    }

    private void readOutput(InputStream input, StringBuffer buffer) {
        try {
            int c;
            while ((c = input.read()) != -1) {
                buffer.append((char)c);
            }
        }
        catch (Exception e) {
            this.exceptionOccurred(e);
        }
    }

    private class OuputReadingRunnable
    implements Runnable {
        public InputStream input;
        public StringBuffer buffer;

        public OuputReadingRunnable(InputStream input, StringBuffer buffer) {
            this.input = input;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            CommandRunner.this.readOutput(this.input, this.buffer);
        }
    }
}

