/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.SearchObserver;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.util.regex.Pattern;

public class ContentReplacingSearchObserver
implements SearchObserver {
    private Pattern searchPattern;
    private String replacement;

    public ContentReplacingSearchObserver(String searchPattern, String replacement) {
        this.searchPattern = Pattern.compile(searchPattern);
        this.replacement = replacement;
    }

    @Override
    public void hit(WikiPage page) throws Exception {
        PageData pageData = page.getData();
        String replacedContent = this.searchPattern.matcher(pageData.getContent()).replaceAll(this.replacement);
        pageData.setContent(replacedContent);
        page.commit(pageData);
    }
}

