/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.FitNesseContext;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import util.Clock;

public class RecentChanges {
    private static final String RECENT_CHANGES = "RecentChanges";

    private static SimpleDateFormat makeDateFormat() {
        return new SimpleDateFormat(FitNesseContext.recentChangesDateFormat);
    }

    public static void updateRecentChanges(PageData pageData) throws Exception {
        RecentChanges.createRecentChangesIfNecessary(pageData);
        RecentChanges.addCurrentPageToRecentChanges(pageData);
    }

    public static List<String> getRecentChangesLines(PageData recentChangesdata) throws Exception {
        String content = recentChangesdata.getContent();
        BufferedReader reader = new BufferedReader(new StringReader(content));
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    private static void addCurrentPageToRecentChanges(PageData data) throws Exception {
        WikiPage recentChanges = data.getWikiPage().getPageCrawler().getRoot(data.getWikiPage()).getChildPage(RECENT_CHANGES);
        String resource = RecentChanges.resource(data);
        PageData recentChangesdata = recentChanges.getData();
        List<String> lines = RecentChanges.getRecentChangesLines(recentChangesdata);
        RecentChanges.removeDuplicate(lines, resource);
        lines.add(0, RecentChanges.makeRecentChangesLine(data));
        RecentChanges.trimExtraLines(lines);
        String content = RecentChanges.convertLinesToWikiText(lines);
        recentChangesdata.setContent(content);
        recentChanges.commit(recentChangesdata);
    }

    private static String resource(PageData data) throws Exception {
        WikiPagePath fullPath = data.getWikiPage().getPageCrawler().getFullPath(data.getWikiPage());
        String resource = PathParser.render(fullPath);
        return resource;
    }

    private static void createRecentChangesIfNecessary(PageData data) throws Exception {
        PageCrawler crawler = data.getWikiPage().getPageCrawler();
        WikiPage root = crawler.getRoot(data.getWikiPage());
        if (!root.hasChildPage(RECENT_CHANGES)) {
            crawler.addPage(root, PathParser.parse(RECENT_CHANGES), "");
        }
    }

    private static String makeRecentChangesLine(PageData data) throws Exception {
        String user = data.getAttribute("LastModifyingUser");
        if (user == null) {
            user = "";
        }
        return "|" + RecentChanges.resource(data) + "|" + user + "|" + RecentChanges.makeDateFormat().format(Clock.currentDate()) + "|";
    }

    private static void removeDuplicate(List<String> lines, String resource) {
        ListIterator<String> iterator = lines.listIterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!s.startsWith("|" + resource + "|")) continue;
            iterator.remove();
        }
    }

    private static String convertLinesToWikiText(List<String> lines) {
        StringBuffer buffer = new StringBuffer();
        for (String s : lines) {
            buffer.append(s).append("\n");
        }
        return buffer.toString();
    }

    private static void trimExtraLines(List<String> lines) {
        while (lines.size() > 100) {
            lines.remove(100);
        }
    }
}

