/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.PageFinder;
import fitnesse.components.SearchObserver;
import fitnesse.components.TraversalListener;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiWordReference;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.parser.WikiWord;
import java.util.ArrayList;
import java.util.List;

public class WhereUsedPageFinder
implements TraversalListener,
SearchObserver,
PageFinder,
SymbolTreeWalker {
    private WikiPage subjectPage;
    private SearchObserver observer;
    private WikiPage currentPage;
    private List<WikiPage> hits = new ArrayList<WikiPage>();

    public WhereUsedPageFinder(WikiPage subjectPage, SearchObserver observer) {
        this.subjectPage = subjectPage;
        this.observer = observer;
    }

    @Override
    public void hit(WikiPage referencingPage) throws Exception {
    }

    @Override
    public void processPage(WikiPage currentPage) throws Exception {
        this.currentPage = currentPage;
        String content = currentPage.getData().getContent();
        Symbol syntaxTree = Parser.make(new ParsingPage(new WikiSourcePage(currentPage)), content, SymbolProvider.refactoringProvider).parse();
        syntaxTree.walkPreOrder(this);
    }

    @Override
    public List<WikiPage> search(WikiPage page) throws Exception {
        this.hits.clear();
        this.subjectPage.getPageCrawler().traverse(page, this);
        return this.hits;
    }

    @Override
    public boolean visit(Symbol node) {
        if (!node.isType(WikiWord.symbolType)) {
            return true;
        }
        if (this.hits.contains(this.currentPage)) {
            return true;
        }
        try {
            WikiPage referencedPage = new WikiWordReference(this.currentPage, node.getContent()).getReferencedPage();
            if (referencedPage != null && referencedPage.equals(this.subjectPage)) {
                this.hits.add(this.currentPage);
                this.observer.hit(this.currentPage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public boolean visitChildren(Symbol node) {
        return true;
    }
}

