/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.ColumnFixture;
import fitnesse.fixtures.FitnesseFixtureContext;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.StringTokenizer;

public class PageCreator
extends ColumnFixture {
    public String pageName;
    public String pageContents;
    public String pageAttributes = "";

    public boolean valid() throws Exception {
        try {
            if (this.pageContents != null) {
                this.pageContents = this.pageContents.replaceAll("<br>", "\n");
                this.pageContents = this.pageContents.replaceAll("<br/>", "\n");
            }
            WikiPage root = FitnesseFixtureContext.root;
            WikiPagePath pagePath = PathParser.parse(this.pageName);
            WikiPage thePage = root.getPageCrawler().addPage(root, pagePath, this.pageContents);
            PageData data = thePage.getData();
            this.setAttributes(data);
            thePage.commit(data);
            this.setPageAttributes("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void setAttributes(PageData data) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(this.pageAttributes, ",");
        while (tokenizer.hasMoreTokens()) {
            String nameValuePair = tokenizer.nextToken();
            int equals = nameValuePair.indexOf("=");
            if (equals < 0) {
                throw new Exception("Attribute must have form name=value");
            }
            String name = nameValuePair.substring(0, equals);
            String value = nameValuePair.substring(equals + 1);
            data.setAttribute(name, value);
        }
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public void setPageContents(String pageContents) {
        this.pageContents = pageContents;
    }

    public void setPageAttributes(String pageAttributes) {
        this.pageAttributes = pageAttributes;
    }
}

