/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.MockRequest;
import fitnesse.http.Request;

public class MockRequestBuilder {
    protected String specification;

    public MockRequestBuilder(String specification) {
        this.specification = specification;
        this.validate();
    }

    public Request build() {
        MockRequest request = new MockRequest();
        request.parseRequestUri(this.getCommand());
        if (this.hasCredentials()) {
            ((Request)request).setCredentials(this.getUsername(), this.getPassword());
        }
        return request;
    }

    private String getCommand() {
        String actualCommand = null;
        actualCommand = this.hasCredentials() ? this.commandParts()[2] : this.specification;
        if (actualCommand.startsWith("/")) {
            return actualCommand;
        }
        return "/" + actualCommand;
    }

    private boolean hasCredentials() {
        return this.commandParts().length == 3;
    }

    private boolean hasNoCredentials() {
        return this.commandParts().length == 1;
    }

    private void validate() {
        if (!this.hasCredentials() && !this.hasNoCredentials()) {
            throw new IllegalArgumentException("Command specification [" + this.specification + "] invalid. Format shold be /cmd or user:pass:/cmd");
        }
    }

    private String[] commandParts() {
        return this.specification.split(":");
    }

    private String getUsername() {
        return this.commandParts()[0];
    }

    private String getPassword() {
        return this.commandParts()[1];
    }
}

